/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.util.NxUtil;

public class Literal
implements Node,
Serializable {
    private static Logger _log = Logger.getLogger(Literal.class.getName());
    protected String _data = null;
    protected String _lang = null;
    protected Resource _dt = null;
    protected String _wholeString = null;
    @Deprecated
    public static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    @Deprecated
    public static final Resource STRING = new Resource("http://www.w3.org/2001/XMLSchema#string");
    @Deprecated
    public static final Resource BOOLEAN = new Resource("http://www.w3.org/2001/XMLSchema#boolean");
    @Deprecated
    public static final Resource FLOAT = new Resource("http://www.w3.org/2001/XMLSchema#float");
    @Deprecated
    public static final Resource DECIMAL = new Resource("http://www.w3.org/2001/XMLSchema#decimal");
    @Deprecated
    public static final Resource DOUBLE = new Resource("http://www.w3.org/2001/XMLSchema#double");
    @Deprecated
    public static final Resource DATETIME = new Resource("http://www.w3.org/2001/XMLSchema#dateTime");
    private static final Pattern PATTERN = Pattern.compile("(?:\"(.*)\")(?:@([a-z]+(?:-[a-zA-Z0-9]+)*)|\\^\\^(<\\S+>))?");
    private static final long serialVersionUID = 8911891129019471564L;

    public Literal(String string) {
        this(string, null, null);
    }

    public Literal(String string, String string2) {
        this(string, string2, null);
    }

    public Literal(String string, Resource resource) {
        this(string, null, resource);
    }

    public Literal(String string, String string2, Resource resource) {
        this(string, string2, resource, false);
    }

    public Literal(String string, String string2, Resource resource, boolean bl) {
        if (!bl) {
            if (string.equals("") || string.charAt(0) != '\"' || string.charAt(string.length() - 1) != '\"') {
                _log.fine("String for Literal (" + string + ") had no surrounding quotes. Adding some and proceeding...");
                string = '\"' + string + '\"';
            }
            if (string2 != null && resource != null) {
                throw new IllegalArgumentException("In Nx, only one of language and datatype can be given.");
            }
            this._wholeString = string + (string2 == null ? (resource == null ? "" : "^^" + resource.toN3()) : "@" + string2);
            if (resource != null) {
                this._dt = resource;
            }
        } else {
            this._wholeString = string;
        }
    }

    public Literal(String string, boolean bl) {
        this(string, null, null, bl);
    }

    public String getData() {
        if (this._data == null) {
            Matcher matcher = PATTERN.matcher(this._wholeString);
            if (matcher.matches()) {
                this._data = matcher.group(1);
            } else {
                _log.warning("Something wrong with the literal-backing string. The parsing regex pattern didn't match. Check the string for correct N3 syntax. The malicious string is: " + this._wholeString);
            }
        }
        return this._data;
    }

    public String getMarkupEscapedData() {
        return NxUtil.escapeForMarkup(this.getData());
    }

    public String getUnescapedData() {
        return NxUtil.unescape(this.getData());
    }

    public String getLanguageTag() {
        if (this._lang == null) {
            Matcher matcher = PATTERN.matcher(this._wholeString);
            if (!matcher.matches()) {
                _log.warning("The parsing regex pattern didn't match, so no language tag is returned. Check the Literal for proper N3 syntax. The malicious Literal was: " + this._wholeString);
            } else {
                this._lang = matcher.group(2);
            }
        }
        return this._lang;
    }

    public boolean isConstant() {
        return true;
    }

    public Resource getDatatype() {
        if (this._dt == null) {
            Matcher matcher = PATTERN.matcher(this._wholeString);
            if (matcher.matches()) {
                if (matcher.group(3) == null) {
                    return null;
                }
                this._dt = new Resource(matcher.group(3), true);
            } else {
                _log.warning("Something wrong with the Resource. Its String: " + this._wholeString + " didn't match the parsing regex pattern. Probably it's no proper N3.");
            }
        }
        return this._dt;
    }

    @Override
    public String toString() {
        return NxUtil.unescape(this.getData());
    }

    @Override
    public String toN3() {
        return this._wholeString;
    }

    @Override
    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            return this._wholeString.compareTo(literal._wholeString);
        }
        if (object instanceof Resource) {
            return -536870912;
        }
        if (object instanceof BNode) {
            return -715827882;
        }
        if (object instanceof Unbound) {
            return -1073741824;
        }
        if (object instanceof Variable) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type Literal but " + object.getClass().getName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object != null && object instanceof Literal && ((Literal)object)._wholeString.equals(this._wholeString);
    }

    @Override
    public int hashCode() {
        return this._wholeString.hashCode();
    }

    protected int getHashCode() {
        return this.hashCode();
    }

    public static String escapeForNx(String string) {
        return NxUtil.escapeForNx(string);
    }

    public static String escapeForMarkup(String string) {
        return NxUtil.escapeForMarkup(string);
    }

    public static String unescape(String string) {
        return NxUtil.unescape(string);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
    }
}

