/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.ParseException;

public class BNode
implements Serializable,
Node {
    public static String PREFIX = "_:";
    public static boolean PRETTY_PRINT = false;
    protected String _data;
    private static final long serialVersionUID = 6233987125715026425L;

    public BNode(String string) {
        this(string, false);
    }

    public BNode(String string, boolean bl) {
        this._data = bl ? string : (!string.startsWith(PREFIX) ? PREFIX + string : string);
    }

    @Override
    public String toString() {
        if (PRETTY_PRINT) {
            try {
                String[] stringArray = this.parseContextualBNode();
                return stringArray[1] + "@[" + stringArray[0] + "]";
            }
            catch (ParseException parseException) {
                return BNode.unescapeForBNode(this._data.substring(PREFIX.length()));
            }
        }
        return this._data.substring(PREFIX.length());
    }

    @Override
    public int hashCode() {
        return this._data.hashCode();
    }

    @Override
    public String toN3() {
        return this._data;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BNode) {
            return this._data.equals(((BNode)object)._data);
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object instanceof BNode) {
            BNode bNode = (BNode)object;
            return this._data.compareTo(bNode._data);
        }
        if (object instanceof Resource) {
            return 0x3FFFFFFF;
        }
        if (object instanceof Literal) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof Unbound) {
            return -1073741824;
        }
        if (object instanceof Variable) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type BNode but " + object.getClass().getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (!this._data.startsWith(PREFIX)) {
            this._data = PREFIX + this._data;
        }
    }

    public String[] parseContextualBNode() throws ParseException {
        String string = this._data.substring(PREFIX.length());
        String[] stringArray = string.toString().split("xx");
        if (stringArray.length != 2) {
            throw new ParseException("This is not a valid context encoded BNode");
        }
        stringArray[0] = BNode.unescapeForBNode(stringArray[0]);
        stringArray[1] = BNode.unescapeForBNode(stringArray[1]);
        return stringArray;
    }

    public static String[] parseContextualBNode(BNode bNode) throws ParseException {
        String[] stringArray = bNode.toString().split("xx");
        if (stringArray.length != 2) {
            throw new ParseException("Not a valid context encoded BNode " + bNode);
        }
        stringArray[0] = BNode.unescapeForBNode(stringArray[0]);
        stringArray[1] = BNode.unescapeForBNode(stringArray[1]);
        return stringArray;
    }

    public static BNode createBNode(String string, String string2) {
        String string3 = BNode.escapeForBNode(string);
        String string4 = BNode.escapeForBNode(string2);
        return new BNode(string4 + "xx" + string3);
    }

    public static BNode createBNode(String string) {
        String string2 = BNode.escapeForBNode(string);
        return new BNode(string2);
    }

    public static String escapeForBNode(String string) {
        try {
            return URLEncoder.encode(string, "utf-8").replace("x", "x78").replace("-", "x2D").replace(".", "x2E").replace("_", "x5F").replace('%', 'x');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String unescapeForBNode(String string) {
        try {
            return URLDecoder.decode(string.replace('x', '%'), "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static void main(String[] stringArray) throws ParseException {
        String string = "http://asdj.com/-xx42xxx/%20thing/";
        System.err.println(BNode.escapeForBNode(string));
        System.err.println(BNode.unescapeForBNode(BNode.escapeForBNode(string)));
        System.err.println(BNode.createBNode(string, "xx78x"));
        for (String string2 : BNode.parseContextualBNode(BNode.createBNode(string, "xx78x"))) {
            System.err.println(string2);
        }
    }
}

