/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars2.rdfxml;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.parser.Callback;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RDFXMLParserBase
extends DefaultHandler {
    private boolean _skolemise = false;
    private String _escapedDocURI = null;
    public static final String BNODE_PREFIX = "bnode";
    private static final String XML_BASE = "xml:base";
    private static final String XML_LANG = "xml:lang";
    private static final String NULL = "";
    private ArrayList<Node> _fifoS;
    private ScopedThing<URI> _sbq;
    private ScopedThing<String> _slang;
    private TreeSet<Integer> _sptl;
    private TreeSet<Integer> _sptr;
    private HashMap<Integer, Integer> _li;
    private HashMap<Integer, Node> _coll;
    private HashSet<String> _ids;
    private URI _currentBase;
    private int _currentLi = 0;
    private Node _currentColl = null;
    private Node _currentReify = null;
    private int _depth = 0;
    private int _bnode = 0;
    private String _currentLang = null;
    private Resource _datatype = null;
    private HashMap<String, String> _xmllPrefixes = null;
    private StringBuffer _prefixDefinition = null;
    private State _state = State.START;
    private ResourceDescription _currentPRD = null;
    private Node _currentS = null;
    private Resource _currentP = null;
    private Locator _loc = null;
    private StringBuffer _currentL = null;
    private Callback _c;
    private static final Node[] NOT_ALLOWED_NODE = new Node[]{RDF.ABOUT, RDF.DATATYPE, RDF.ID, RDF.NODEID, RDF.PARSETYPE, RDF.RESOURCE};
    private static final HashSet<Node> NOT_ALLOWED_NODE_TS = new HashSet();
    private static final String[] RDF_SUBJ_NODE_NAMES = new String[]{"Description", "Bag", "Seq", "Alt", "List", "Statement", "Property"};
    private static final String[] RDF_PROP_NODE_NAMES = new String[]{"type", "subject", "predicate", "object", "first", "rest", "value", "li"};
    private static final String[] RDF_SUBJ_ATTR_NAMES = new String[]{"about", "ID", "nodeID", "type"};
    private static final String[] RDF_PROP_ATTR_NAMES = new String[]{"ID", "nodeID", "datatype", "parseType", "resource"};
    private static final HashSet<String> RDF_SUBJ_NODE_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_PROP_NODE_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_SUBJ_ATTR_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_PROP_ATTR_NAMES_TS = new HashSet();

    public RDFXMLParserBase(String string, Callback callback) throws SAXException {
        this(string, callback, true);
    }

    public RDFXMLParserBase(String string, Callback callback, boolean bl) throws SAXException {
        for (Node object : NOT_ALLOWED_NODE) {
            NOT_ALLOWED_NODE_TS.add(object);
        }
        for (String string2 : RDF_SUBJ_NODE_NAMES) {
            RDF_SUBJ_NODE_NAMES_TS.add(string2);
        }
        for (String string3 : RDF_PROP_NODE_NAMES) {
            RDF_PROP_NODE_NAMES_TS.add(string3);
        }
        for (String string4 : RDF_SUBJ_ATTR_NAMES) {
            RDF_SUBJ_ATTR_NAMES_TS.add(string4);
        }
        for (String string5 : RDF_PROP_ATTR_NAMES) {
            RDF_PROP_ATTR_NAMES_TS.add(string5);
        }
        this._fifoS = new ArrayList();
        this.initialiseBaseURI(string);
        this.setDocumentURI(string);
        this._sbq = new ScopedThing<URI>(this._currentBase);
        this._sptr = new TreeSet();
        this._sptl = new TreeSet();
        this._slang = new ScopedThing<String>(NULL);
        this._li = new HashMap();
        this._coll = new HashMap();
        this._ids = new HashSet();
        this._skolemise = bl;
        this._c = callback;
    }

    private void setDocumentURI(String string) {
        try {
            this._escapedDocURI = URLEncoder.encode(string, "utf-8").replace("-", "-2D").replace(".", "-2E").replace("_", "-5F").replace('%', '-');
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this._c.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this._c.endDocument();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Resource resource;
        if (string == null || string.equals(NULL) && !this._state.equals(State.PTL_XML)) {
            if (string2.equals("RDF") && this._state.equals(State.START)) {
                this.warning("Unqualified use of rdf:RDF is deprecated.");
                resource = RDF.RDF;
            } else if (RDF_SUBJ_NODE_NAMES_TS.contains(string2) && this._state.expectOpenResource()) {
                this.warning("Unqualified use of RDF name " + string2 + " is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else if (RDF_PROP_NODE_NAMES_TS.contains(string2) && this._state.expectOpenProperty()) {
                this.warning("Unqualified use of RDF name " + string2 + " is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else {
                this.error("Unqualified attribute name " + string2 + " found. Resolving against baseURI.");
                resource = new Resource(this.resolveFullURI(string2, false));
            }
        } else {
            resource = new Resource(string + string2);
        }
        this.nodeIsAllowed(string3, resource);
        if (this._state.equals(State.START)) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getQName(i);
                String string5 = attributes.getValue(i);
                if (string4.equals(XML_BASE)) {
                    this.initialiseBaseURI(string5);
                    this._sbq.addNewScopedElement(this._currentBase);
                }
                this._state = State.OR;
            }
            if (!resource.equals(RDF.RDF)) {
                this.initialiseCurrentResource(resource, attributes);
                this._state = State.CR_OP;
            }
        } else if (this._state.equals(State.OR)) {
            this.initialiseCurrentResource(resource, attributes);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.CR_OP)) {
            this._state = State.T_CP_OR;
            this.initialiseCurrentProperty(resource, attributes);
        } else if (this._state.equals(State.T_CP_OR)) {
            this._currentL = null;
            Node node = this._currentS;
            this.initialiseCurrentResource(resource, attributes);
            this.handleStatement(node, this._currentP, this._currentS);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.CP)) {
            this.fatalError("Expecting close property tag, not open element tag '" + string3 + "'.");
        } else if (this._state.equals(State.T_CP)) {
            this.fatalError("Expecting close property, not open element tag '" + string3 + "'.");
        } else if (this._state.equals(State.PTC_OR_CP)) {
            BNode bNode = this.generateBNode();
            if (this._currentColl == null) {
                this.handleStatement(this._currentS, this._currentP, bNode);
                this._fifoS.add(this._currentS);
            } else {
                this.handleStatement(this._currentColl, RDF.REST, bNode);
            }
            this.initialiseCurrentResource(resource, attributes);
            this.handleStatement(bNode, RDF.FIRST, this._currentS);
            this._currentColl = null;
            this._coll.put(this._depth, bNode);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.PTL_XML)) {
            this.handleParseTypeLiteralStartElement(string, string2, string3, attributes);
        } else if (this._state.equals(State.PTR_OP_CP)) {
            Node node = this._currentS;
            this._currentS = this.generateBNode();
            this._fifoS.add(this._currentS);
            this.handleStatement(node, this._currentP, this._currentS);
            this._state = State.T_CP_OR;
            this.initialiseCurrentProperty(resource, attributes);
        }
        this._sbq.incrementScope();
        this._slang.incrementScope();
    }

    private void handleParseTypeLiteralStartElement(String string, String string2, String string3, Attributes attributes) {
        this.checkXMLLiteralPrefix(string, string2, string3);
        this._currentL.append("<" + string3);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this._currentL.append(" " + attributes.getQName(i) + "=" + attributes.getValue(i));
            this.checkXMLLiteralPrefix(attributes.getURI(i), attributes.getQName(i), attributes.getLocalName(i));
        }
        if (this._prefixDefinition != null) {
            this._currentL.append(this._prefixDefinition.toString());
            this._prefixDefinition = null;
        }
        this._currentL.append(">");
    }

    private void checkAndHandleBaseURI(Attributes attributes) throws SAXException {
        int n = attributes.getIndex(XML_BASE);
        if (n == -1) {
            return;
        }
        this.initialiseBaseURI(attributes.getValue(n));
        this._sbq.addNewScopedElement(this._currentBase);
    }

    private void checkAndHandleLang(Attributes attributes) throws SAXException {
        int n = attributes.getIndex(XML_LANG);
        if (n == -1) {
            return;
        }
        this.initialiseLang(attributes.getValue(n));
        this._slang.addNewScopedElement(this._currentLang);
    }

    private void initialiseLang(String string) throws SAXException {
        this._currentLang = string;
    }

    private void initialiseBaseURI(String string) throws SAXException {
        if (string.contains(" ")) {
            this.warning("Base uri " + string + " contains a space. Replacing with '+'!");
            string = string.replaceAll(" ", "+");
        }
        try {
            this._currentBase = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.fatalError(new SAXException(uRISyntaxException));
        }
        if (!this._currentBase.isAbsolute()) {
            this.fatalError(new SAXException(new RDFXMLParseException("Cannot have relative xml:base value: " + string + ". " + this.getLocation())));
        }
    }

    private void initialiseCurrentResource(Resource resource, Attributes attributes) throws SAXException {
        this._currentLi = 0;
        this._currentS = null;
        ResourceDescription resourceDescription = new ResourceDescription();
        if (!resource.equals(RDF.DESCRIPTION)) {
            resourceDescription.addEdge(RDF.TYPE, resource);
        }
        this.checkAndHandleBaseURI(attributes);
        this.checkAndHandleLang(attributes);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node[] nodeArray = this.handleSubjectAttributePair(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
            if (nodeArray == null) continue;
            resourceDescription.addEdge(nodeArray);
        }
        if (this._currentS == null) {
            this._currentS = this.generateBNode();
        }
        this._fifoS.add(this._currentS);
        for (Node[] nodeArray : resourceDescription.getEdges()) {
            this.handleStatement(this._currentS, nodeArray[0], nodeArray[1]);
        }
    }

    private Node[] handleSubjectAttributePair(String string, String string2, String string3, String string4) throws SAXException {
        Resource resource;
        if (string == null || string.equals(NULL)) {
            if (RDF_SUBJ_ATTR_NAMES_TS.contains(string2)) {
                this.warning("Unqualified use of RDF name " + string2 + " is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else {
                this.error("Unqualified attribute name " + string2 + " found. Resolving against baseURI.");
                resource = new Resource(this.resolveFullURI(string2, false));
            }
        } else {
            resource = new Resource(string + string2);
        }
        if (resource.equals(RDF.ABOUT)) {
            if (this._currentS != null) {
                this.fatalError("Multiple definitions for identity of resource.");
            }
            this._currentS = new Resource(this.resolveFullURI(string4, false));
            return null;
        }
        if (resource.equals(RDF.ID)) {
            if (this._currentS != null) {
                this.fatalError("Multiple definitions for identity of resource.");
            }
            this._currentS = new Resource(this.resolveFullURI(string4, true));
            return null;
        }
        if (resource.equals(RDF.NODEID)) {
            if (this._currentS != null) {
                this.fatalError("Multiple definitions for identity of resource.");
            }
            this._currentS = this.generateBNode(string4);
            return null;
        }
        if (resource.equals(RDF.TYPE)) {
            return new Node[]{RDF.TYPE, new Resource(string4)};
        }
        if (string3.equals(XML_BASE)) {
            return null;
        }
        if (string3.equals(XML_LANG)) {
            return null;
        }
        return new Node[]{resource, this.createLiteral(string4)};
    }

    private String resolveFullURI(String string, boolean bl) throws SAXException {
        URI uRI = null;
        int n = string.length();
        if (n != (string = string.trim()).length()) {
            this.warning("Trimmed whitespace from id " + string + ".");
        }
        if (string.contains(" ")) {
            this.warning("ID " + string + " contains a space. Replacing with '+'!");
            string = string.replaceAll(" ", "+");
        }
        if (bl && !this._ids.add(string)) {
            this.warning("Duplicate value '" + string + "' for rdf:ID attribute. " + this.getLocation());
        }
        try {
            uRI = bl ? new URI("#" + string) : new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.fatalError(new SAXException(uRISyntaxException));
        }
        if (uRI.isAbsolute()) {
            if (bl) {
                this.error("Absolute URI provided for rdf:ID. Not resolving against base URI.");
            }
            return string;
        }
        return this._currentBase.resolve(uRI).toString();
    }

    private Literal createLiteral(String string) {
        Literal literal;
        if (this._datatype != null) {
            literal = new Literal(Literal.escapeForNx(string), this._datatype);
            this._datatype = null;
        } else {
            literal = this._currentLang != null ? new Literal(Literal.escapeForNx(string), this._currentLang) : new Literal(Literal.escapeForNx(string));
        }
        return literal;
    }

    private void initialiseCurrentProperty(Resource resource, Attributes attributes) throws SAXException {
        this._currentP = resource;
        if (this._currentP.equals(RDF.LI)) {
            ++this._currentLi;
            this._li.put(this._depth, this._currentLi);
            this._currentP = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this._currentLi);
        }
        ++this._depth;
        this.checkAndHandleBaseURI(attributes);
        this.checkAndHandleLang(attributes);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.handlePropertyAttributePair(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i));
        }
        if (this._currentPRD != null) {
            Node node = this._currentPRD.getIdentifier();
            if (node == null) {
                node = this.generateBNode();
            }
            for (Node[] nodeArray : this._currentPRD.getEdges()) {
                this.handleStatement(node, nodeArray[0], nodeArray[1]);
            }
            this._currentPRD = null;
        }
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (this._state.equals(State.PTL_XML)) {
            this.handleXMLLiteralPrefixMapping(string, string2);
        }
    }

    private void handleXMLLiteralPrefixMapping(String string, String string2) {
        this._xmllPrefixes.put(string, string2);
        if (this._prefixDefinition == null) {
            this._prefixDefinition = new StringBuffer();
        }
        this._prefixDefinition.append(" " + this.createPrefixDefinition(string, string2));
    }

    private String createPrefixDefinition(String string, String string2) {
        return "xmlns:" + string + "=\"" + string2 + "\"";
    }

    private String getPrefix(String string, String string2) {
        return string.substring(0, string.length() - (string2.length() + 1));
    }

    private void checkXMLLiteralPrefix(String string, String string2, String string3) {
        if (string.equals(NULL)) {
            return;
        }
        String string4 = this.getPrefix(string3, string2);
        if (this._xmllPrefixes.get(string4) == null) {
            this.handleXMLLiteralPrefixMapping(string4, string);
        }
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        if (this._state.equals(State.PTL_XML)) {
            this._xmllPrefixes.remove(string);
        }
    }

    private void handlePropertyAttributePair(String string, String string2, String string3, String string4) throws SAXException {
        Resource resource;
        if (string == null || string.equals(NULL)) {
            if (RDF_PROP_ATTR_NAMES_TS.contains(string2)) {
                this.warning("Unqualified use of RDF name " + string2 + " is deprecated.");
                resource = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + string2);
            } else {
                this.error("Unqualified attribute name " + string2 + " found. Resolving against baseURI.");
                resource = new Resource(this.resolveFullURI(string2, false));
            }
        } else {
            resource = new Resource(string + string2);
        }
        if (resource.equals(RDF.RESOURCE)) {
            if (this._currentPRD != null && this._currentPRD.getIdentifier() != null) {
                this.fatalError("Cannot have more than one rdf:resource/rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:resource attached as attributes to a property.");
            }
            Resource resource2 = new Resource(this.resolveFullURI(string4, false));
            this.handleStatement(this._currentS, this._currentP, resource2);
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription(resource2);
            } else {
                this._currentPRD.setIdentifier(resource2);
            }
            this._state = State.CP;
        } else if (resource.equals(RDF.NODEID)) {
            if (this._currentPRD != null && this._currentPRD.getIdentifier() != null) {
                this.fatalError("Cannot have more than one rdf:resource/rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:nodeID attached as attributes to a property.");
            }
            BNode bNode = this.generateBNode(string4);
            this.handleStatement(this._currentS, this._currentP, bNode);
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription(bNode);
            } else {
                this._currentPRD.setIdentifier(bNode);
            }
            this._state = State.CP;
        } else if (resource.equals(RDF.TYPE)) {
            if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:type attached as attributes to a property.");
            }
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription();
            }
            this._currentPRD.addEdge(RDF.TYPE, new Resource(string4));
            this._state = State.CP;
        } else if (!string3.equals(XML_BASE) && !string3.equals(XML_LANG)) {
            if (resource.equals(RDF.DATATYPE)) {
                if (this._state.equals(State.CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:resource attached as attributes to a property.");
                } else if (this._state.equals(State.PTC_OR_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Collection' attached as attributes to a property.");
                } else if (this._state.equals(State.PTL_XML)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Literal' attached as attributes to a property.");
                } else if (this._state.equals(State.PTR_OP_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Resource' attached as attributes to a property.");
                }
                this._datatype = new Resource(this.resolveFullURI(string4, false));
                this._state = State.T_CP;
            } else if (resource.equals(RDF.PARSETYPE)) {
                if (string4.equals("Collection")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTL_XML)) {
                        this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTR_OP_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:parseType='Collection' attached as attributes to a property.");
                    }
                    this._state = State.PTC_OR_CP;
                } else if (string4.equals("Literal")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTC_OR_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTR_OP_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:parseType='Literal' attached as attributes to a property.");
                    }
                    this._state = State.PTL_XML;
                    this._sptl.add(this._depth);
                    this._xmllPrefixes = new HashMap();
                    this._currentL = new StringBuffer();
                } else if (string4.equals("Resource")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTC_OR_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTL_XML)) {
                        this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:parseType='Resource' attached as attributes to a property.");
                    }
                    this._currentL = null;
                    this._sptr.add(this._depth);
                    this._state = State.PTR_OP_CP;
                }
            } else if (resource.equals(RDF.ID)) {
                this._currentReify = new Resource(this.resolveFullURI(string4, true));
            } else {
                if (this._state.equals(State.T_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and " + string3 + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTC_OR_CP)) {
                    this.fatalError("Cannot have both rdf:parseType='Collection' and " + string3 + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTL_XML)) {
                    this.fatalError("Cannot have both rdf:parseType='Literal' and " + string3 + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTR_OP_CP)) {
                    this.fatalError("Cannot have both rdf:parseType='Resource' and " + string3 + " attached as attributes to a property.");
                }
                if (this._currentPRD == null) {
                    this._currentPRD = new ResourceDescription();
                }
                this._currentPRD.addEdge(resource, this.createLiteral(string4));
                this._state = State.CP;
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        Resource resource = new Resource(string + string2);
        URI uRI = this._sbq.decrementScope();
        if (uRI != null) {
            this._currentBase = uRI;
        }
        boolean bl = this._sptr.remove(this._depth);
        boolean bl2 = this._sptl.remove(this._depth);
        if (!resource.equals(RDF.RDF) && !this._state.equals(State.OR)) {
            if (this._state.equals(State.CR_OP)) {
                this._fifoS.remove(this._fifoS.size() - 1);
                this._li.remove(this._depth);
                if (bl) {
                    this._currentS = this._fifoS.get(this._fifoS.size() - 1);
                    object = this._li.get(this._depth - 1);
                    if (object != null) {
                        this._currentLi = (Integer)object;
                    }
                    --this._depth;
                } else if (this._depth > 0) {
                    this._currentS = this._fifoS.get(this._fifoS.size() - 1);
                    object = this._li.get(this._depth - 1);
                    if (object != null) {
                        this._currentLi = (Integer)object;
                    }
                    this._state = State.CP;
                    Node node = this._coll.get(this._depth);
                    if (node != null) {
                        this._currentColl = node;
                        this._state = State.PTC_OR_CP;
                    }
                } else {
                    this._state = State.START;
                }
            } else if (this._state.equals(State.T_CP_OR) || this._state.equals(State.T_CP)) {
                object = NULL;
                if (this._currentL != null) {
                    object = this._currentL.toString();
                }
                Literal literal = this.createLiteral((String)object);
                this.handleStatement(this._currentS, this._currentP, literal);
                this._currentL = null;
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.CP)) {
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this._coll.remove(this._depth);
                if (this._currentColl != null) {
                    this.handleStatement(this._currentColl, RDF.REST, RDF.NIL);
                    this._currentColl = null;
                } else {
                    this.handleStatement(this._currentS, this._currentP, RDF.NIL);
                }
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.PTL_XML)) {
                this.handleParseTypeLiteralEndElement(string, string2, string3);
                if (bl2) {
                    object = NULL;
                    this._state = State.CP;
                    if (this._currentL != null) {
                        object = this._currentL.toString();
                    }
                    this._datatype = RDF.XMLLITERAL;
                    Literal literal = this.createLiteral((String)object);
                    this.handleStatement(this._currentS, this._currentP, literal);
                    this._currentL = null;
                    --this._depth;
                }
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.handleStatement(this._currentS, this._currentP, this.generateBNode());
                --this._depth;
                this._state = State.CR_OP;
            }
        }
        if ((object = this._slang.decrementScope()) != null) {
            this._currentLang = ((String)object).equals(NULL) ? null : object;
        }
    }

    private void handleParseTypeLiteralEndElement(String string, String string2, String string3) {
        this._currentL.append("</" + string3 + ">");
    }

    private BNode generateBNode() {
        ++this._bnode;
        if (this._skolemise) {
            return new BNode(this._escapedDocURI + "--" + BNODE_PREFIX + (this._bnode - 1));
        }
        return new BNode(BNODE_PREFIX + (this._bnode - 1));
    }

    private BNode generateBNode(String string) throws SAXException {
        int n = string.length();
        if (n != (string = string.trim()).length()) {
            this.warning("Trimmed whitespace from rdf:nodeID " + string + ".");
        }
        if (this._skolemise) {
            return new BNode(this._escapedDocURI + "--" + string);
        }
        return new BNode(string);
    }

    private void warning(String string) throws SAXException {
        SAXException sAXException = new SAXException(new RDFXMLParseException("WARNING: " + string + " " + this.getLocation()));
        this.warning(sAXException);
    }

    private void error(String string) throws SAXException {
        SAXException sAXException = new SAXException(new RDFXMLParseException("ERROR: " + string + " " + this.getLocation()));
        this.error(sAXException);
    }

    private void fatalError(String string) throws SAXException {
        SAXException sAXException = new SAXException(new RDFXMLParseException("FATAL ERROR: " + string + " " + this.getLocation()));
        this.fatalError(sAXException);
    }

    public void warning(SAXException sAXException) throws SAXException {
        System.err.println(sAXException);
    }

    public void error(SAXException sAXException) throws SAXException {
        System.err.println(sAXException);
    }

    public void fatalError(SAXException sAXException) throws SAXException {
        System.err.println(sAXException);
        throw sAXException;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        String string = new String(cArray2);
        if (this._state.expectText()) {
            if (this._currentL == null) {
                this._currentL = new StringBuffer();
            }
            this._currentL.append(string);
        }
    }

    private boolean nodeIsAllowed(String string, Resource resource) throws SAXException {
        if (NOT_ALLOWED_NODE_TS.contains(resource)) {
            this.error("Attribute '" + string + "' not allowed to be used as a node element.");
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, n, cArray2, 0, n2);
        String string = new String(cArray2);
        boolean bl = string.trim().equals(NULL);
        if (bl) {
            this.ignorableWhitespace(cArray, n, n2);
            return;
        }
        if (this._state.expectText()) {
            if (this._currentL == null) {
                if (this._state.equals(State.PTL_XML)) {
                    this.fatalError("Dangling text '" + string + "' found outside of enclosing tags, inside parseType=\"Literal\" tags.");
                }
                this._currentL = new StringBuffer();
            }
            this._currentL.append(string);
            if (this._state.equals(State.T_CP_OR)) {
                this._state = State.T_CP;
            }
        } else {
            this.fatalError("Dangling text '" + string + "' found outside of enclosing property tags.");
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this._loc = locator;
    }

    private String getLocation() {
        if (this._loc != null) {
            return "Line " + this._loc.getLineNumber() + " column " + this._loc.getColumnNumber() + ".";
        }
        return NULL;
    }

    private void handleStatement(Node ... nodeArray) {
        this.processStatement(nodeArray);
        if (this._currentReify != null) {
            this.processStatement(this._currentReify, RDF.TYPE, RDF.STATEMENT);
            this.processStatement(this._currentReify, RDF.SUBJECT, nodeArray[0]);
            this.processStatement(this._currentReify, RDF.PREDICATE, nodeArray[1]);
            this.processStatement(this._currentReify, RDF.OBJECT, nodeArray[2]);
        }
    }

    private void processStatement(Node ... nodeArray) {
        this._c.processStatement(nodeArray);
    }

    public static class ScopedThing<E> {
        private LinkedList<Integer> _skip = new LinkedList();
        private LinkedList<E> _scoped = new LinkedList();
        private int _currentSkip = -1;
        private E _current = null;
        private E _global;

        public ScopedThing() {
            this(null);
        }

        public boolean inScope(E e) {
            if (this._current != null && this._current.equals(e)) {
                return true;
            }
            if (this._global != null && this._global.equals(e)) {
                return true;
            }
            return this._scoped.contains(e);
        }

        public ScopedThing(E e) {
            this._global = e;
        }

        public void incrementScope() {
            if (this._currentSkip != -1) {
                ++this._currentSkip;
            }
        }

        public E decrementScope() {
            if (this._currentSkip == -1) {
                return null;
            }
            --this._currentSkip;
            if (this._currentSkip == 0) {
                if (this._skip.size() > 0) {
                    this._currentSkip = this._skip.removeLast();
                    this._current = this._scoped.removeLast();
                    return this._current;
                }
                return this._global;
            }
            return null;
        }

        public void addNewScopedElement(E e) {
            if (this._currentSkip != -1) {
                this._skip.add(this._currentSkip);
                this._scoped.add(this._current);
            }
            this._currentSkip = 0;
            this._current = e;
        }

        public void setCurrent(E e) {
            this._current = e;
        }
    }

    public static class RDFXMLParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public RDFXMLParseException() {
        }

        public RDFXMLParseException(String string) {
            super(string);
        }
    }

    public static class ResourceDescription {
        private Node _id = null;
        private ArrayList<Node[]> _edges = new ArrayList();

        public ResourceDescription() {
        }

        public ResourceDescription(Node node) {
            this._id = node;
        }

        public void setIdentifier(Node node) {
            this._id = node;
        }

        public Node getIdentifier() {
            return this._id;
        }

        public void addEdge(Node ... nodeArray) {
            this._edges.add(nodeArray);
        }

        public ArrayList<Node[]> getEdges() {
            return this._edges;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._id == null) {
                for (Node[] nodeArray : this._edges) {
                    System.err.print(Nodes.toN3(nodeArray) + "\n");
                }
            }
            for (Node[] nodeArray : this._edges) {
                stringBuffer.append(this._id.toN3() + " " + Nodes.toN3(nodeArray) + "\n");
            }
            return stringBuffer.toString();
        }
    }

    private static enum State implements Comparable<State>
    {
        START,
        OR,
        CR_OP,
        T_CP_OR,
        CP,
        T_CP,
        PTC_OR_CP,
        PTL_XML,
        PTR_OP_CP;


        public boolean expectCloseProperty() {
            return this.equals(T_CP_OR) || this.equals(CP) || this.equals(T_CP) || this.equals(PTC_OR_CP) || this.equals(PTL_XML);
        }

        public boolean expectCloseResource() {
            return this.equals(CR_OP) || this.equals(PTL_XML);
        }

        public boolean expectText() {
            return this.equals(T_CP_OR) || this.equals(T_CP) || this.equals(PTL_XML);
        }

        public boolean expectOpenResource() {
            return this.equals(START) || this.equals(OR) || this.equals(T_CP_OR) || this.equals(PTC_OR_CP) || this.equals(PTL_XML);
        }

        public boolean expectOpenProperty() {
            return this.equals(CR_OP) || this.equals(PTR_OP_CP) || this.equals(PTL_XML);
        }

        public boolean equals(State state) {
            if (state == null) {
                return false;
            }
            return state.ordinal() == this.ordinal();
        }
    }
}

