/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars2.rdfxml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars2.rdfxml.BlockingCallBack;
import org.semanticweb.yars2.rdfxml.ParserThread;
import org.semanticweb.yars2.rdfxml.PrintCallBack;
import org.semanticweb.yars2.rdfxml.RDFXMLParserBase;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RDFXMLParser {
    private BlockingQueue<Node[]> _q = null;
    private boolean _done = false;
    private Exception _e = null;
    private ParserThread _pt = null;
    private Node[] _current = null;
    public static final int DEFAULT_BUFFER = 1000;
    public static final int TIME_OUT = 1000;
    private static final Header[] _headers = new Header[]{new Header("Accept", "application/rdf+xml"), new Header("User-Agent", "nxparser/java")};
    public static SAXParser _parser;

    public RDFXMLParser(InputStream inputStream, String string) throws ParseException, IOException {
        this(inputStream, false, true, string, 1000);
    }

    public RDFXMLParser(InputStream inputStream, boolean bl, boolean bl2, String string) throws ParseException, IOException {
        this(inputStream, bl, bl2, string, 1000);
    }

    public RDFXMLParser(InputStream inputStream, boolean bl, boolean bl2, String string, int n) throws ParseException, IOException {
        Object object = SAXParserFactory.newInstance();
        ((SAXParserFactory)object).setNamespaceAware(true);
        ((SAXParserFactory)object).setValidating(false);
        try {
            _parser = ((SAXParserFactory)object).newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        try {
            this._q = new ArrayBlockingQueue<Node[]>(n);
            object = new BlockingCallBack(this._q);
            this._pt = new ParserThread(_parser, inputStream, new RDFXMLParserBase(string, (Callback)object, bl2), this._q);
            this._pt.start();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public RDFXMLParser(InputStream inputStream, boolean bl, boolean bl2, String string, Callback callback) throws ParseException, IOException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        try {
            _parser = sAXParserFactory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(bl);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new RDFXMLParserBase(string, callback, bl2));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public RDFXMLParser(URL uRL, boolean bl, boolean bl2, Callback callback) throws ParseException, IOException {
        this(uRL, bl, bl2, uRL.toString(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDFXMLParser(URL uRL, boolean bl, boolean bl2, String string, Callback callback) throws ParseException, IOException {
        Object object;
        Object object2 = SAXParserFactory.newInstance();
        ((SAXParserFactory)object2).setNamespaceAware(true);
        ((SAXParserFactory)object2).setValidating(false);
        try {
            _parser = ((SAXParserFactory)object2).newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        object2 = new HttpClient();
        if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyPort") != null) {
            object = ((HttpClient)object2).getHostConfiguration();
            ((HostConfiguration)object).setProxy(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
        }
        object = new GetMethod(uRL.toString());
        InputStream inputStream = null;
        int n = -1;
        for (Header header : _headers) {
            ((HttpMethodBase)object).setRequestHeader(header);
        }
        try {
            ((HttpClient)object2).executeMethod((HttpMethod)object);
            n = ((HttpMethodBase)object).getStatusCode();
            if (n == 200) {
                inputStream = ((HttpMethodBase)object).getResponseBodyAsStream();
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                sAXParserFactory.setValidating(bl);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.parse(inputStream, (DefaultHandler)new RDFXMLParserBase(string, callback, bl2));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (n != 200 && n != 204) {
                throw new IOException("returned response code " + n + " " + ((HttpMethodBase)object).getStatusLine());
            }
            ((HttpMethodBase)object).releaseConnection();
        }
    }

    public boolean hasNext() {
        if (this._q == null) {
            return false;
        }
        if (this._done) {
            return false;
        }
        if (this._current != null) {
            if (this._current.length == 0) {
                this._done = true;
                this._e = this._pt.getException();
                return false;
            }
            return true;
        }
        if (this._q.size() > 0) {
            this._current = (Node[])this._q.poll();
            return this.hasNext();
        }
        try {
            this._current = this._q.poll(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            this._done = true;
            return false;
        }
        return this.hasNext();
    }

    public Node[] next() {
        if (this._current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node[] nodeArray = new Node[this._current.length];
        System.arraycopy(this._current, 0, nodeArray, 0, this._current.length);
        this._current = null;
        return nodeArray;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isSuccess() {
        return this._e == null;
    }

    public Exception getException() {
        return this._e;
    }

    public static void main(String[] stringArray) throws FileNotFoundException, ParseException, IOException {
        RDFXMLParser rDFXMLParser = new RDFXMLParser(new URL("http://sw.deri.org/~aharth/foaf.rdf"), false, true, new PrintCallBack());
        while (rDFXMLParser.hasNext()) {
            System.err.println(Nodes.toN3(rDFXMLParser.next()));
        }
    }
}

