/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

public class Statistics {
    public static final Resource RDFTYPE = new Resource("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
    Count<Node> _classes = new Count();
    Count<Node> _predicates = new Count();
    HashSet<Integer> _objects = new HashSet();
    HashSet<Integer> _sources = new HashSet();
    int _instances = 0;
    int _lines = 0;
    int _bnodes = 0;
    int _uris = 0;

    public void count(Iterator<Node[]> iterator, boolean bl) throws IOException, ParseException {
        boolean bl2;
        Node[] nodeArray = null;
        Node node = null;
        TreeSet<Node> treeSet = new TreeSet<Node>();
        TreeSet<Node> treeSet2 = new TreeSet<Node>();
        boolean bl3 = bl2 = !iterator.hasNext();
        while (!bl2) {
            boolean bl4 = bl2 = !iterator.hasNext();
            if (!bl2) {
                ++this._lines;
                nodeArray = iterator.next();
            }
            if (this._lines % 1000000 == 0) {
                System.err.println("Done " + this._lines);
            }
            if (node == null) {
                node = nodeArray[0];
            } else if (!((Object)node).equals(nodeArray[0]) || !iterator.hasNext()) {
                ++this._instances;
                if (node instanceof BNode) {
                    ++this._bnodes;
                    for (Node node2 : treeSet2) {
                        this._classes.add(node2);
                    }
                } else if (node instanceof Resource) {
                    ++this._uris;
                    for (Node node2 : treeSet2) {
                        this._classes.add(node2);
                    }
                } else {
                    System.err.println("oldSub is a " + node.getClass().getName());
                }
                treeSet2 = new TreeSet();
                node = nodeArray[0];
            }
            treeSet.add(nodeArray[3]);
            if (((Object)nodeArray[1]).equals(RDFTYPE)) {
                treeSet2.add(nodeArray[2]);
            }
            this._predicates.add(nodeArray[1]);
            if (!bl) continue;
            this._sources.add(((Object)nodeArray[3]).hashCode());
        }
    }

    public void printStats() {
        System.out.println("Number of classes " + this._classes.size());
        System.out.println("Number of subjects " + this._instances);
        System.out.println("Number of predicates " + this._predicates.size());
        System.out.println("Number of contexts " + this._sources.size());
        System.out.println("Number of quadruples " + this._lines);
        System.out.println("Number of anonymous nodes " + this._bnodes);
        System.out.println("Number of URI identified nodes " + this._uris);
    }

    public void printClasses() {
        this._classes.printStats();
    }

    public void printPredicates() {
        this._predicates.printStats();
    }

    public class Count<T> {
        Hashtable<T, Integer> _ht = new Hashtable();

        public void add(T t) {
            if (this._ht.containsKey(t)) {
                Integer n = this._ht.get(t);
                this._ht.put(t, new Integer(n + 1));
            } else {
                this._ht.put(t, new Integer(1));
            }
        }

        public void printStats() {
            for (Map.Entry<T, Integer> entry : this._ht.entrySet()) {
                System.out.println(entry.getKey() + "\t" + entry.getValue());
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (Map.Entry<T, Integer> entry : this._ht.entrySet()) {
                stringBuffer.append(entry.getKey() + "\t" + entry.getValue() + "\n");
            }
            return stringBuffer.toString();
        }

        public int size() {
            return this._ht.size();
        }
    }
}

