/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.stats;

import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.namespace.Namespace;

public interface NodeTransformer<E> {
    public E[] processNode(Node[] var1);

    public static class NamespaceHashTransformer
    implements NodeTransformer<Integer> {
        public static final int EMPTY_NS_HASH = 0;

        public Integer[] processNode(Node[] nodeArray) {
            Integer[] integerArray = new Integer[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                String string = Namespace.getNamespace(nodeArray[i]);
                integerArray[i] = string == null ? Integer.valueOf(0) : Integer.valueOf(string.hashCode());
            }
            return integerArray;
        }
    }

    public static class NamespaceTransformer
    implements NodeTransformer<String> {
        public static final String EMPTY_NS = "N/A";

        public String[] processNode(Node[] nodeArray) {
            String[] stringArray = new String[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                stringArray[i] = Namespace.getNamespace(nodeArray[i]);
                if (stringArray[i] != null) continue;
                stringArray[i] = EMPTY_NS;
            }
            return stringArray;
        }
    }

    public static class HashTransformer
    implements NodeTransformer<Integer> {
        public Integer[] processNode(Node[] nodeArray) {
            Integer[] integerArray = new Integer[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                integerArray[i] = ((Object)nodeArray[i]).hashCode();
            }
            return integerArray;
        }
    }

    public static class NoTransformer
    implements NodeTransformer<Node> {
        public Node[] processNode(Node[] nodeArray) {
            return nodeArray;
        }
    }
}

