/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.BooleanLiteral;
import org.semanticweb.yars.nx.DateTimeLiteral;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NumericLiteral;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.BNodeHandler;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.ParseException;

public class NxParser
implements Iterator<Node[]> {
    private boolean _strict;
    private static BNodeHandler _bnh;
    private Node[] _current;
    private int _lineNo;
    private BufferedReader _r;
    private static final Header[] _headers;

    public NxParser(InputStream inputStream) throws ParseException, IOException {
        this(inputStream, false);
    }

    public NxParser(InputStream inputStream, boolean bl) throws IOException {
        this._strict = bl;
        this._lineNo = 0;
        this._r = new BufferedReader(new InputStreamReader(inputStream));
        this.init();
    }

    public NxParser(InputStream inputStream, Callback callback) throws ParseException, IOException {
        this._r = new BufferedReader(new InputStreamReader(inputStream));
        this.init();
        callback.startDocument();
        while (this.hasNext()) {
            Node[] nodeArray = this.next();
            callback.processStatement(nodeArray);
        }
        callback.endDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NxParser(URL uRL, Callback callback) throws ParseException, IOException {
        Object object;
        HttpClient httpClient = new HttpClient();
        if (System.getProperty("http.proxyHost") != null && System.getProperty("http.proxyPort") != null) {
            object = httpClient.getHostConfiguration();
            ((HostConfiguration)object).setProxy(System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")));
        }
        object = new GetMethod(uRL.toString());
        InputStream inputStream = null;
        int n = -1;
        for (Header header : _headers) {
            ((HttpMethodBase)object).setRequestHeader(header);
        }
        try {
            httpClient.executeMethod((HttpMethod)object);
            n = ((HttpMethodBase)object).getStatusCode();
            if (n == 200) {
                inputStream = ((HttpMethodBase)object).getResponseBodyAsStream();
                this._r = new BufferedReader(new InputStreamReader(inputStream));
                this.init();
                callback.startDocument();
                while (this.hasNext()) {
                    Serializable[] serializableArray = this.next();
                    callback.processStatement((Node[])serializableArray);
                }
                callback.endDocument();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            if (n != 200 && n != 204) {
                throw new IOException("returned response code " + n + " " + ((HttpMethodBase)object).getStatusLine());
            }
            ((HttpMethodBase)object).releaseConnection();
        }
    }

    private void init() throws IOException {
        String string;
        _bnh = new DummyBNodeHandler();
        while ((string = this._r.readLine()) != null) {
            ++this._lineNo;
            try {
                Node[] nodeArray = NxParser.parseNodes(string);
                if (nodeArray == null) continue;
                this._current = new Node[nodeArray.length];
                System.arraycopy(nodeArray, 0, this._current, 0, nodeArray.length);
                break;
            }
            catch (ParseException parseException) {
                if (this._strict) {
                    throw new RuntimeException(new ParseException(parseException));
                }
                System.err.println("warning on line " + this._lineNo + " " + string + " : " + parseException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                if (this._strict) {
                    throw runtimeException;
                }
                System.err.println("warning in NqParser constructor " + this._lineNo + " " + string + " " + runtimeException.getMessage());
            }
        }
    }

    public void setBNodeHandler(BNodeHandler bNodeHandler) {
        _bnh = bNodeHandler;
    }

    public BNodeHandler getBNodeHandler() {
        return _bnh;
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public Node[] next() {
        Node[] nodeArray = new Node[this._current.length];
        System.arraycopy(this._current, 0, nodeArray, 0, this._current.length);
        this._current = null;
        try {
            String string;
            while ((string = this._r.readLine()) != null) {
                ++this._lineNo;
                try {
                    Node[] nodeArray2 = NxParser.parseNodes(string);
                    if (nodeArray2 == null) continue;
                    this._current = new Node[nodeArray2.length];
                    System.arraycopy(nodeArray2, 0, this._current, 0, nodeArray2.length);
                    break;
                }
                catch (ParseException parseException) {
                    System.err.println("warning in NqParser.next on line " + this._lineNo + " " + string + " : " + parseException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("warning on line " + this._lineNo + " " + string + " : " + runtimeException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return nodeArray;
    }

    public static Node[] parseNodes(String string) throws ParseException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = string.trim();
        while (!(string2 = string2.substring(n).trim()).equals(".") && !string2.equals("\n")) {
            if (string2.startsWith("_")) {
                n2 = string2.indexOf(" ");
                arrayList.add(NxParser.parseBNode(string2, 2, n2));
            } else if (string2.startsWith("<")) {
                n2 = string2.indexOf("> ");
                arrayList.add(NxParser.parseResource(string2, 1, n2));
            } else if (string2.startsWith("\"")) {
                block16: {
                    n2 = string2.indexOf(34, 1);
                    do {
                        boolean bl = false;
                        for (int i = n2 - 1; i > 0 && string2.charAt(i) == '\\'; --i) {
                            bl = !bl;
                        }
                        if (!bl) break block16;
                        if (++n2 != string2.length()) continue;
                        throw new ParseException("Cannot find the (unescaped) \" end of literal");
                    } while ((n2 = string2.indexOf(34, n2)) != -1);
                    throw new ParseException("Cannot find the (unescaped) \" end of literal");
                }
                arrayList.add(NxParser.parseLiteral(string2, 1, n2));
                if (string2.charAt(n2 + 1) == '@') {
                    n2 = string2.indexOf(32, n2 + 1) - 1;
                } else if (string2.charAt(n2 + 1) == '^') {
                    n2 = string2.indexOf(62, n2 + 1);
                }
            } else if (string2.startsWith("?")) {
                n2 = string2.indexOf(" ");
                arrayList.add(NxParser.parseVariable(string2, 1, n2));
            } else if (string2.startsWith("UNBOUND")) {
                arrayList.add(new Unbound());
                n2 = "UNBOUND".length();
            } else {
                throw new ParseException("cannot parse " + n3 + "th element: " + string2);
            }
            n = n2 + 1;
            ++n3;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private static Resource parseResource(String string, int n, int n2) throws ParseException {
        if (n2 <= -1) {
            throw new ParseException("Error parsing resource subject from triple:\n" + string + "\nExpected ending '> ' not found.\n");
        }
        String string2 = string.substring(n, n2);
        return new Resource(string2);
    }

    private static Variable parseVariable(String string, int n, int n2) throws ParseException {
        if (n2 <= -1) {
            throw new ParseException("Error parsing variable from segment:\n" + string + "\nExpected ending ' ' not found\n");
        }
        String string2 = string.substring(n, n2);
        return new Variable(string2);
    }

    private static BNode parseBNode(String string, int n, int n2) throws ParseException {
        if (n2 <= -1) {
            throw new ParseException("Error parsing bnode subject from triple:\n" + string + "\nExpected ending ' ' not found.\n");
        }
        String string2 = string.substring(n, n2);
        return _bnh.getBNode(string2);
    }

    public static Literal parseLiteral(String string) throws ParseException {
        if (string.charAt(0) != '\"') {
            throw new ParseException("literal must be enclosed with \"\"");
        }
        return NxParser.parseLiteral(string, 1, string.length());
    }

    public static Variable parseVariable(String string) throws ParseException {
        if (string.charAt(0) != '?') {
            throw new ParseException("variable must start with ?");
        }
        return NxParser.parseVariable(string, 1, string.length());
    }

    public static Resource parseResource(String string) throws ParseException {
        if (string.charAt(0) != '<' && string.charAt(string.length() - 1) != '>') {
            throw new ParseException("resource must be enclosed with <>");
        }
        return NxParser.parseResource(string, 1, string.length() - 1);
    }

    public static BNode parseBNode(String string) throws ParseException {
        if (string.charAt(0) != '_' || string.charAt(1) != ':') {
            throw new ParseException("bnode must be enclosed with <>");
        }
        String string2 = string.substring(2, string.length());
        return new BNode(string2);
    }

    public static Node parseNode(String string) throws ParseException {
        if (string.charAt(0) == '_') {
            return NxParser.parseBNode(string);
        }
        if (string.charAt(0) == '<') {
            return NxParser.parseResource(string);
        }
        if (string.charAt(0) == '\"') {
            return NxParser.parseLiteral(string);
        }
        if (string.charAt(0) == '?') {
            return NxParser.parseVariable(string);
        }
        throw new ParseException("cannot parse " + string);
    }

    private static Literal parseLiteral(String string, int n, int n2) throws ParseException {
        String string2;
        if (n2 <= -1) {
            throw new ParseException("Error parsing object literal from triple :\n" + string + "\nCannot find closing object delimiter '\"'.\n");
        }
        int n3 = string.lastIndexOf(34, n2);
        String string3 = string.substring(n, n3);
        ++n3;
        try {
            string2 = string.substring(n3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParseException("Error checking for datatype/lang property of object literal from triple :\n" + string + "\nNo closing '.' in triple?\n");
        }
        string2.trim();
        if (string2.startsWith("@")) {
            int n4 = string2.indexOf(32);
            if (n4 < 0) {
                n4 = string2.length();
            }
            String string4 = string2.substring(1, n4).trim();
            return new Literal(string3, string4);
        }
        if (string2.startsWith("^^")) {
            Resource resource;
            n2 = string2.indexOf("> ");
            if (n2 <= -1) {
                if (string2.charAt(string2.length() - 1) == '>') {
                    n2 = string2.length() - 1;
                } else {
                    throw new ParseException("Error checking for datatype property of object literal from triple :\n" + string + "\nNo closing > after datatype property\n");
                }
            }
            if ((resource = new Resource(string2.substring(3, n2))).equals(DateTimeLiteral.DATETIME)) {
                return new DateTimeLiteral(string3);
            }
            if (resource.equals(BooleanLiteral.BOOLEAN)) {
                return BooleanLiteral.getEffectiveBooleanLit(new Literal(string3, resource));
            }
            if (NumericLiteral.NUMBERS.contains(resource)) {
                return NumericLiteral.getNumericLiteral(new Literal(string3, resource));
            }
            return new Literal(string3, resource);
        }
        return new Literal(string3, (String)null);
    }

    static {
        _headers = new Header[]{new Header("Accept", "application/rdf+nq"), new Header("User-Agent", "nxparser/java")};
    }

    private class DummyBNodeHandler
    implements BNodeHandler {
        private DummyBNodeHandler() {
        }

        @Override
        public BNode getBNode(String string) {
            return new BNode(string);
        }
    }
}

