/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.BNodeHandler;
import org.semanticweb.yars.nx.parser.ParseException;

public class NqParser
implements Iterator<Node[]> {
    private boolean _strict;
    private BNodeHandler _bnh;
    private Node[] _current;
    private BufferedReader _br;
    private int _lineNo;

    public NqParser(Reader reader) throws ParseException, IOException {
        this(reader, false);
    }

    public NqParser(Reader reader, boolean bl) throws IOException {
        String string;
        this._strict = bl;
        this._lineNo = 0;
        this._bnh = new DummyBNodeHandler();
        this._br = new BufferedReader(reader);
        while ((string = this._br.readLine()) != null) {
            ++this._lineNo;
            try {
                Node[] nodeArray = this.parseNodes(string);
                if (nodeArray == null) continue;
                this._current = new Node[nodeArray.length];
                System.arraycopy(nodeArray, 0, this._current, 0, nodeArray.length);
                break;
            }
            catch (ParseException parseException) {
                if (this._strict) {
                    throw new RuntimeException(new ParseException(parseException));
                }
                System.err.println("warning on line " + this._lineNo + " " + string + " : " + parseException.getMessage());
            }
            catch (RuntimeException runtimeException) {
                if (this._strict) {
                    throw runtimeException;
                }
                System.err.println("warning in NqParser constructor " + this._lineNo + " " + string + " " + runtimeException.getMessage());
            }
        }
    }

    public NqParser(Reader reader, boolean bl, boolean bl2) throws IOException {
        this(reader, bl2);
    }

    public void setBNodeHandler(BNodeHandler bNodeHandler) {
        this._bnh = bNodeHandler;
    }

    public BNodeHandler getBNodeHandler() {
        return this._bnh;
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public Node[] next() {
        Node[] nodeArray = new Node[this._current.length];
        System.arraycopy(this._current, 0, nodeArray, 0, this._current.length);
        this._current = null;
        try {
            String string;
            while ((string = this._br.readLine()) != null) {
                ++this._lineNo;
                try {
                    Node[] nodeArray2 = this.parseNodes(string);
                    if (nodeArray2 == null) continue;
                    this._current = new Node[nodeArray2.length];
                    System.arraycopy(nodeArray2, 0, this._current, 0, nodeArray2.length);
                    break;
                }
                catch (ParseException parseException) {
                    System.err.println("warning in NqParser.next on line " + this._lineNo + " " + string + " : " + parseException.getMessage());
                }
                catch (RuntimeException runtimeException) {
                    System.err.println("warning on line " + this._lineNo + " " + string + " : " + runtimeException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return nodeArray;
    }

    private Node[] parseNodes(String string) throws ParseException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = string.trim();
        while (!(string2 = string2.substring(n).trim()).equals(".") && !string2.equals("\n")) {
            if (string2.startsWith("_")) {
                n2 = string2.indexOf(" ");
                arrayList.add(this.parseBNode(string2, 2, n2));
            } else if (string2.startsWith("<")) {
                n2 = string2.indexOf("> ");
                arrayList.add(NqParser.parseResource(string2, 1, n2));
            } else if (string2.startsWith("\"")) {
                block14: {
                    n2 = string2.indexOf(34, 2);
                    do {
                        boolean bl = false;
                        for (int i = n2 - 1; i > 0 && string2.charAt(i) == '\\'; --i) {
                            bl = !bl;
                        }
                        if (!bl) break block14;
                        if (++n2 != string2.length()) continue;
                        throw new ParseException("Cannot find the (unescaped) \" end of literal");
                    } while ((n2 = string2.indexOf(34, n2)) != -1);
                    throw new ParseException("Cannot find the (unescaped) \" end of literal");
                }
                arrayList.add(NqParser.parseLiteral(string2, 1, n2));
                if (string2.charAt(n2 + 1) == '@') {
                    n2 = string2.indexOf(32, n2 + 1) - 1;
                } else if (string2.charAt(n2 + 1) == '^') {
                    n2 = string2.indexOf(62, n2 + 1);
                }
            } else if (string2.startsWith("?")) {
                n2 = string2.indexOf(" ");
                arrayList.add(NqParser.parseVariable(string2, 1, n2));
            } else {
                throw new ParseException("cannot parse " + n3 + "th element: " + string2);
            }
            n = n2 + 1;
            ++n3;
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private static Resource parseResource(String string, int n, int n2) throws ParseException {
        if (n2 <= -1) {
            throw new ParseException("Error parsing resource subject from triple:\n" + string + "\nExpected ending '> ' not found.\n");
        }
        String string2 = string.substring(n, n2);
        return new Resource(string2);
    }

    private static Variable parseVariable(String string, int n, int n2) throws ParseException {
        if (n2 <= -1) {
            throw new ParseException("Error parsing variable from segment:\n" + string + "\nExpected ending ' ' not found\n");
        }
        String string2 = string.substring(n, n2);
        return new Variable(string2);
    }

    private BNode parseBNode(String string, int n, int n2) throws ParseException {
        if (n2 <= -1) {
            throw new ParseException("Error parsing bnode subject from triple:\n" + string + "\nExpected ending ' ' not found.\n");
        }
        String string2 = string.substring(n, n2);
        return this._bnh.getBNode(string2);
    }

    public static Literal parseLiteral(String string) throws ParseException {
        if (string.charAt(0) != '\"') {
            throw new ParseException("literal must be enclosed with \"\"");
        }
        return NqParser.parseLiteral(string, 1, string.length());
    }

    public static Variable parseVariable(String string) throws ParseException {
        if (string.charAt(0) != '?') {
            throw new ParseException("variable must start with ?");
        }
        return NqParser.parseVariable(string, 1, string.length());
    }

    public static Resource parseResource(String string) throws ParseException {
        if (string.charAt(0) != '<' && string.charAt(string.length() - 1) != '>') {
            throw new ParseException("resource must be enclosed with <>");
        }
        return NqParser.parseResource(string, 1, string.length() - 1);
    }

    public static BNode parseBNode(String string) throws ParseException {
        if (string.charAt(0) != '_' || string.charAt(1) != ':') {
            throw new ParseException("bnode must be enclosed with <>");
        }
        String string2 = string.substring(2, string.length());
        return new BNode(string2);
    }

    public static Node parseNode(String string) throws ParseException {
        if (string.charAt(0) == '_') {
            return NqParser.parseBNode(string);
        }
        if (string.charAt(0) == '<') {
            return NqParser.parseResource(string);
        }
        if (string.charAt(0) == '\"') {
            return NqParser.parseLiteral(string);
        }
        if (string.charAt(0) == '?') {
            return NqParser.parseVariable(string);
        }
        throw new ParseException("cannot parse " + string);
    }

    private static Literal parseLiteral(String string, int n, int n2) throws ParseException {
        String string2;
        if (n2 <= -1) {
            throw new ParseException("Error parsing object literal from triple :\n" + string + "\nCannot find closing object delimiter '\"'.\n");
        }
        int n3 = string.lastIndexOf(34);
        String string3 = string.substring(n, n3);
        ++n3;
        try {
            string2 = string.substring(n3);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParseException("Error checking for datatype/lang property of object literal from triple :\n" + string + "\nNo closing '.' in triple?\n");
        }
        string2.trim();
        if (string2.startsWith("@")) {
            int n4 = string2.indexOf(32);
            if (n4 < 0) {
                n4 = string2.length();
            }
            String string4 = string2.substring(1, n4).trim();
            return new Literal(string3, string4);
        }
        if (string2.startsWith("^^")) {
            n2 = string2.indexOf("> ");
            if (n2 <= -1) {
                if (string2.charAt(string2.length() - 1) == '>') {
                    n2 = string2.length() - 1;
                } else {
                    throw new ParseException("Error checking for datatype property of object literal from triple :\n" + string + "\nNo closing > after datatype property\n");
                }
            }
            Resource resource = new Resource(string2.substring(3, n2));
            return new Literal(string3, resource);
        }
        return new Literal(string3, (String)null);
    }

    private class DummyBNodeHandler
    implements BNodeHandler {
        private DummyBNodeHandler() {
        }

        @Override
        public BNode getBNode(String string) {
            return new BNode(string);
        }
    }
}

