/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.filter;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.filter.NodeFilter;

public class FilterIterator
implements Iterator<Node[]> {
    private Iterator<Node[]> _in;
    private NodeFilter[] _nf;
    private Node[] _current;

    public FilterIterator(Iterator<Node[]> iterator, NodeFilter[] nodeFilterArray) {
        this._in = iterator;
        this._nf = nodeFilterArray;
        this.getNext();
    }

    @Override
    public boolean hasNext() {
        return this._current != null;
    }

    @Override
    public Node[] next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Node[] nodeArray = this._current;
        this.getNext();
        return nodeArray;
    }

    private void getNext() {
        this._current = null;
        if (!this._in.hasNext()) {
            return;
        }
        while (this._in.hasNext()) {
            Node[] nodeArray = this._in.next();
            if (!FilterIterator.check(this._nf, nodeArray)) continue;
            this._current = nodeArray;
            return;
        }
    }

    public static boolean check(NodeFilter[] nodeFilterArray, Node[] nodeArray) {
        if (nodeFilterArray == null) {
            return true;
        }
        for (int i = 0; i < nodeFilterArray.length; ++i) {
            NodeFilter nodeFilter = nodeFilterArray[i];
            if (nodeFilter == null || nodeFilter.check(nodeArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

