/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli.factory;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.filter.FilterIterator;
import org.semanticweb.yars.nx.filter.NodeFilter;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;
import org.semanticweb.yars.stats.CountStmtAnalyser;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DOMConfigFileHandler {
    String _doc;
    Document _dom;
    Iterator<Node[]> _currentIter = null;
    NodeFilter[] _currentFilt = null;
    boolean _input = true;
    private static final int DEFAULT_STMT_LENGTH = 4;

    public DOMConfigFileHandler(String string) {
        this._doc = string;
    }

    public void parse() throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this._dom = documentBuilder.parse(this._doc);
    }

    public Iterator<Node[]> create() throws DOMException, ParseException, IOException, ConfigFileParseException {
        NodeList nodeList = this._dom.getChildNodes();
        this.handleIteratorNode(nodeList.item(0));
        return this._currentIter;
    }

    private void handleIteratorNode(org.w3c.dom.Node node) throws DOMException, ParseException, IOException, ConfigFileParseException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            throw new ConfigFileParseException("Missing iterator attributes.");
        }
        org.w3c.dom.Node node2 = namedNodeMap.getNamedItem("type");
        if (node2 == null) {
            throw new ConfigFileParseException("No type attribute.");
        }
        String string = node2.getNodeValue();
        if (string.equals("input")) {
            Object object;
            if (this._currentIter != null) {
                throw new ConfigFileParseException("Iterator type 'input' only allowed as root element.");
            }
            org.w3c.dom.Node node3 = namedNodeMap.getNamedItem("file");
            if (node3 == null) {
                this._currentIter = new NxParser(System.in);
            } else {
                object = new FileInputStream(node3.getNodeValue());
                this._currentIter = new NxParser((InputStream)object);
            }
            this._input = true;
            object = this.handleIteratorChildNode(node);
            if (this._currentFilt != null) {
                this._currentIter = new FilterIterator(this._currentIter, this._currentFilt);
                this._currentFilt = null;
            }
            if (object != null) {
                this.handleIteratorNode((org.w3c.dom.Node)object);
            }
        } else {
            if (this._currentIter == null) {
                this._currentIter = new NxParser(System.in);
                this._input = true;
            }
            if (string.equals("countStmt")) {
                org.w3c.dom.Node node4 = this.handleIteratorChildNode(node);
                this._currentIter = new CountStmtAnalyser(this._currentIter, this._currentFilt);
                this._currentFilt = null;
                if (node4 != null) {
                    this.handleIteratorNode(node4);
                }
            } else if (string.equals("blah")) {
                // empty if block
            }
        }
    }

    private org.w3c.dom.Node handleIteratorChildNode(org.w3c.dom.Node node) throws ConfigFileParseException {
        NodeList nodeList = node.getChildNodes();
        org.w3c.dom.Node node2 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node3 = nodeList.item(i);
            if (node3.getNodeName().equals("iterator")) {
                node2 = node3;
                continue;
            }
            if (!node3.getNodeName().equals("filterStmt")) continue;
            this._currentFilt = this.handleFilterStmt(node3);
        }
        return node2;
    }

    private NodeFilter[] handleFilterStmt(org.w3c.dom.Node node) throws ConfigFileParseException {
        NodeList nodeList = node.getChildNodes();
        NodeFilter[] nodeFilterArray = this.initialiseNodeFilterArray();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("filterElement")) {
                NamedNodeMap namedNodeMap = node2.getAttributes();
                if (namedNodeMap == null) {
                    throw new ConfigFileParseException("Missing 'index' attribute for filterElement");
                }
                org.w3c.dom.Node node3 = namedNodeMap.getNamedItem("index");
                if (node3 == null) {
                    throw new ConfigFileParseException("Missing 'index' attribute for filterElement");
                }
                int n = Integer.parseInt(node3.getNodeValue());
                if (--n >= nodeFilterArray.length) {
                    nodeFilterArray = this.increaseCapacity(nodeFilterArray, n + 1);
                } else if (nodeFilterArray[n] != null) {
                    throw new ConfigFileParseException("Multiple filterElement defined for index " + (n + 1));
                }
                nodeFilterArray[n] = this.handleFilterElement(node2);
                continue;
            }
            if (this.isIgnorable(node2)) continue;
            throw new ConfigFileParseException("Illegal child node of filterStmt: " + node2 + ". Only 'filterElement' allowed.");
        }
        return nodeFilterArray;
    }

    private boolean isIgnorable(org.w3c.dom.Node node) {
        if (node.getNodeType() == 3 && node.getNodeValue().trim().isEmpty()) {
            return true;
        }
        return node.getNodeType() == 8;
    }

    private NodeFilter[] initialiseNodeFilterArray() {
        NodeFilter[] nodeFilterArray = new NodeFilter[4];
        return nodeFilterArray;
    }

    private NodeFilter[] increaseCapacity(NodeFilter[] nodeFilterArray, int n) {
        NodeFilter[] nodeFilterArray2 = new NodeFilter[n];
        System.arraycopy(nodeFilterArray, 0, nodeFilterArray2, 0, nodeFilterArray.length);
        return nodeFilterArray2;
    }

    private NodeFilter handleFilterElement(org.w3c.dom.Node node) throws ConfigFileParseException {
        NodeList nodeList = node.getChildNodes();
        boolean bl = false;
        NodeFilter nodeFilter = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("filter")) {
                if (bl) {
                    throw new ConfigFileParseException("Must have exactly one child node for filterElement.");
                }
                nodeFilter = this.handleFilter(node2, false);
                bl = true;
                continue;
            }
            if (node2.getNodeName().equals("notfilter")) {
                if (bl) {
                    throw new ConfigFileParseException("Must have exactly one child node for filterElement.");
                }
                nodeFilter = this.handleFilter(node2, true);
                bl = true;
                continue;
            }
            if (node2.getNodeName().equals("and")) {
                if (bl) {
                    throw new ConfigFileParseException("Must have exactly one child node for filterElement.");
                }
                nodeFilter = this.handleCompoundFilter(node2, true);
                bl = true;
                continue;
            }
            if (node2.getNodeName().equals("or")) {
                if (bl) {
                    throw new ConfigFileParseException("Must have exactly one child node for filterElement.");
                }
                nodeFilter = this.handleCompoundFilter(node2, false);
                bl = true;
                continue;
            }
            if (this.isIgnorable(node2)) continue;
            throw new ConfigFileParseException("Illegal child node of filterElement: " + node2.getNodeName() + ". Only 'filter' allowed.");
        }
        return nodeFilter;
    }

    private NodeFilter handleCompoundFilter(org.w3c.dom.Node node, boolean bl) throws ConfigFileParseException {
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() < 2) {
            throw new ConfigFileParseException("Must have at least two child nodes for 'and'/'or'.");
        }
        ArrayList<NodeFilter> arrayList = new ArrayList<NodeFilter>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            org.w3c.dom.Node node2 = nodeList.item(i);
            if (node2.getNodeName().equals("filter")) {
                arrayList.add(this.handleFilter(node2, false));
                continue;
            }
            if (node2.getNodeName().equals("notfilter")) {
                arrayList.add(this.handleFilter(node2, true));
                continue;
            }
            if (node2.getNodeName().equals("and")) {
                arrayList.add(this.handleCompoundFilter(node2, true));
                continue;
            }
            if (node2.getNodeName().equals("or")) {
                arrayList.add(this.handleCompoundFilter(node2, false));
                continue;
            }
            if (this.isIgnorable(node2)) continue;
            throw new ConfigFileParseException("Illegal child node of 'and'/'or': " + node2.getNodeName() + ". Only 'filter', 'notFilter', 'and', 'or' allowed.");
        }
        NodeFilter[] nodeFilterArray = new NodeFilter[arrayList.size()];
        arrayList.toArray(nodeFilterArray);
        if (bl) {
            return new NodeFilter.AndFilter(nodeFilterArray);
        }
        return new NodeFilter.OrFilter(nodeFilterArray);
    }

    private NodeFilter.AbstractFilter handleFilter(org.w3c.dom.Node node, boolean bl) throws ConfigFileParseException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            throw new ConfigFileParseException("Missing filter attributes.");
        }
        org.w3c.dom.Node node2 = namedNodeMap.getNamedItem("type");
        if (node2 == null) {
            throw new ConfigFileParseException("No type attribute on filter element.");
        }
        String string = node2.getNodeValue();
        if (string.equals("regex")) {
            org.w3c.dom.Node node3 = namedNodeMap.getNamedItem("value");
            if (node3 == null) {
                throw new ConfigFileParseException("Missing value attribute on 'regex' filter.");
            }
            org.w3c.dom.Node node4 = namedNodeMap.getNamedItem("flag");
            if (node4 == null) {
                return new NodeFilter.RegexFilter(node3.getNodeValue());
            }
            return new NodeFilter.RegexFilter(node3.getNodeValue(), node4.getNodeValue());
        }
        if (string.equals("equals")) {
            org.w3c.dom.Node node5 = namedNodeMap.getNamedItem("value");
            if (node5 == null) {
                throw new ConfigFileParseException("Missing value attribute on 'equals' filter.");
            }
            return new NodeFilter.EqualsFilter(node5.getNodeValue(), bl);
        }
        if (string.equals("class")) {
            Class clazz = null;
            org.w3c.dom.Node node6 = namedNodeMap.getNamedItem("value");
            if (node6 == null) {
                throw new ConfigFileParseException("Missing value attribute on 'class' filter.");
            }
            String string2 = node6.getNodeValue();
            if (string2.equals("uri")) {
                clazz = Resource.class;
            } else if (string2.equals("bnode")) {
                clazz = BNode.class;
            } else if (string2.equals("literal")) {
                clazz = Literal.class;
            } else {
                throw new ConfigFileParseException("Unknown value for attribute 'value' of 'class' filter: " + string2 + ". Must be 'uri', 'bnode' or 'literal'.");
            }
            return new NodeFilter.ClassFilter(clazz, bl);
        }
        throw new ConfigFileParseException("Unknown filter type : " + string);
    }

    public static void main(String[] stringArray) throws Exception {
        DOMConfigFileHandler dOMConfigFileHandler = new DOMConfigFileHandler("test/iterator.txt");
        dOMConfigFileHandler.parse();
        Iterator<Node[]> iterator = dOMConfigFileHandler.create();
        while (iterator.hasNext()) {
            System.err.println(Nodes.toN3(iterator.next()));
        }
    }

    public static class ConfigFileParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ConfigFileParseException() {
        }

        public ConfigFileParseException(String string) {
            super(string);
        }
    }
}

