/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.Hashtable;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.namespace.OWL;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.namespace.RDFS;
import org.semanticweb.yars.nx.parser.NxParser;

public class GetTBox {
    public static void main(String[] stringArray) throws URISyntaxException, IOException {
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        Option option2 = new Option("o", "name of file to write, - for stdout");
        option2.setArgs(1);
        Option option3 = new Option("h", "print help");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        PrintStream printStream = System.out;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        if (commandLine.hasOption("o")) {
            printStream = commandLine.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(commandLine.getOptionValue("o")));
        }
        Hashtable<Resource, Integer> hashtable = new Hashtable<Resource, Integer>();
        Hashtable<Resource, Integer> hashtable2 = new Hashtable<Resource, Integer>();
        hashtable.put(OWL.FUNCTIONALPROPERTY, 0);
        hashtable.put(OWL.INVERSEFUNCTIONALPROPERTY, 0);
        hashtable.put(OWL.SYMMETRICPROPERTY, 0);
        hashtable.put(OWL.TRANSITIVEPROPERTY, 0);
        hashtable2 = new Hashtable();
        hashtable2.put(RDFS.DOMAIN, 0);
        hashtable2.put(RDFS.RANGE, 0);
        hashtable2.put(RDFS.SUBCLASSOF, 0);
        hashtable2.put(RDFS.SUBPROPERTYOF, 0);
        hashtable2.put(RDF.FIRST, 0);
        hashtable2.put(RDF.REST, 0);
        hashtable2.put(OWL.ALLVALUESFROM, 0);
        hashtable2.put(OWL.CARDINALITY, 0);
        hashtable2.put(OWL.MAXCARDINALITY, 0);
        hashtable2.put(OWL.MINCARDINALITY, 0);
        hashtable2.put(OWL.EQUIVALENTCLASS, 0);
        hashtable2.put(OWL.EQUIVALENTPROPERTY, 0);
        hashtable2.put(OWL.HASVALUE, 0);
        hashtable2.put(OWL.INTERSECTIONOF, 0);
        hashtable2.put(OWL.INVERSEOF, 0);
        hashtable2.put(OWL.ONEOF, 0);
        hashtable2.put(OWL.ONPROPERTY, 0);
        hashtable2.put(OWL.SOMEVALUESFROM, 0);
        hashtable2.put(OWL.UNIONOF, 0);
        NxParser nxParser = new NxParser(inputStream, false);
        boolean bl = false;
        while (nxParser.hasNext()) {
            Integer n;
            Node[] nodeArray = nxParser.next();
            if (((Object)nodeArray[1]).equals(RDF.TYPE)) {
                n = (Integer)hashtable.get(nodeArray[2]);
                if (n != null) {
                    bl = true;
                    hashtable.put((Resource)nodeArray[2], n + 1);
                }
            } else {
                n = (Integer)hashtable2.get(nodeArray[1]);
                if (n != null) {
                    bl = true;
                    hashtable2.put((Resource)nodeArray[1], n + 1);
                }
            }
            if (!bl) continue;
            printStream.println(Nodes.toN3(nodeArray));
            bl = false;
        }
    }
}

