/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.NodeComparator;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;

public class CreateFiles {
    public static void main(String[] stringArray) throws IOException, ParseException {
        Node[] nodeArray;
        File file;
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        Option option2 = new Option("o", "output directory");
        option2.setArgs(1);
        option2.setRequired(true);
        Option option3 = new Option("a", "append, not overwrite");
        option3.setArgs(0);
        Option option4 = new Option("s", "only use specified sources");
        option4.setArgs(1);
        Option option5 = new Option("c", "create directory structure");
        option5.setArgs(0);
        Option option6 = new Option("h", "print help");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option5);
        options.addOption(option3);
        options.addOption(option4);
        options.addOption(option6);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (org.apache.commons.cli.ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        if (!(file = new File(commandLine.getOptionValue("o"))).exists()) {
            file.mkdir();
        }
        boolean bl = false;
        if (commandLine.hasOption("c")) {
            bl = true;
        }
        HashSet<Node> hashSet = null;
        if (commandLine.hasOption("s")) {
            hashSet = new HashSet<Node>();
            NxParser nxParser = new NxParser(new FileInputStream(commandLine.getOptionValue("s")));
            while (nxParser.hasNext()) {
                nodeArray = nxParser.next();
                hashSet.add(nodeArray[0]);
            }
        }
        boolean bl2 = false;
        if (commandLine.hasOption("a")) {
            bl2 = true;
        }
        nodeArray = new HashMap();
        NxParser nxParser = new NxParser(inputStream);
        while (nxParser.hasNext()) {
            Object object;
            Node[] nodeArray2 = nxParser.next();
            if (hashSet != null && (hashSet == null || !hashSet.contains(nodeArray2[3]))) continue;
            if (nodeArray.containsKey(nodeArray2[3])) {
                object = (Set)nodeArray.get(nodeArray2[3]);
            } else {
                object = new TreeSet<Node[]>(NodeComparator.NC);
                nodeArray.put(nodeArray2[3], object);
            }
            object.add(nodeArray2);
        }
        inputStream.close();
        for (Object object : nodeArray.keySet()) {
            try {
                if (bl) {
                    URL uRL = new URL(object.toString());
                    String string = uRL.getHost();
                    String string2 = uRL.getPath();
                    string2 = string2.substring(0, string2.lastIndexOf(47));
                    String string3 = uRL.getFile();
                    string3 = string3.substring(string3.lastIndexOf(47) + 1);
                    String string4 = file + "/" + string + "/" + string2;
                    File file2 = new File(string4);
                    file2.mkdirs();
                    CreateFiles.writeFile(file2, string3, (Set)nodeArray.get(object), bl2);
                    continue;
                }
                CreateFiles.writeFile(file, URLEncoder.encode(object.toString(), "utf-8"), (Set)nodeArray.get(object), bl2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
    }

    static void writeFile(File file, String string, Set<Node[]> set, boolean bl) throws FileNotFoundException {
        File file2 = new File(file.getAbsoluteFile() + "/" + string);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2, bl));
        for (Node[] nodeArray : set) {
            printWriter.println(nodeArray[0].toN3() + " " + nodeArray[1].toN3() + " " + nodeArray[2].toN3() + " .");
        }
        printWriter.close();
    }
}

