/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URISyntaxException;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.clean.Cleaner;
import org.semanticweb.yars.nx.parser.NxParser;

public class Clean {
    public static void main(String[] stringArray) throws URISyntaxException, IOException {
        Option option = new Option("i", "name of file to read, - for stdin");
        option.setArgs(1);
        Option option2 = new Option("o", "name of file to write, - for stdout");
        option2.setArgs(1);
        Option option3 = new Option("h", "print help");
        Option option4 = new Option("e", "check that all entries have x elements, will skip other entries");
        option4.setArgs(1);
        Option option5 = new Option("d", "perform datatype normalisation (eperimental!)");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        options.addOption(option4);
        options.addOption(option5);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        InputStream inputStream = System.in;
        PrintStream printStream = System.out;
        int n = -1;
        if (commandLine.hasOption("i")) {
            inputStream = commandLine.getOptionValue("i").equals("-") ? System.in : new FileInputStream(commandLine.getOptionValue("i"));
        }
        if (commandLine.hasOption("o")) {
            printStream = commandLine.getOptionValue("o").equals("-") ? System.out : new PrintStream(new FileOutputStream(commandLine.getOptionValue("o")));
        }
        if (commandLine.hasOption("e")) {
            n = Integer.parseInt(commandLine.getOptionValue("e"));
        }
        boolean bl = false;
        if (commandLine.hasOption("d")) {
            bl = true;
        }
        NxParser nxParser = new NxParser(inputStream, false);
        Cleaner.clean(nxParser, printStream, n, bl);
    }
}

