/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.cli;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.benchmark.BenchPrime;
import org.semanticweb.yars.nx.benchmark.BenchQuery;
import org.semanticweb.yars.nx.benchmark.Query;
import org.semanticweb.yars.nx.namespace.RDF;

public class Benchmark {
    public static void main(String[] stringArray) throws URISyntaxException, IOException {
        List<Long[]> list;
        Option option = new Option("e", "SPARQL endpoint");
        option.setArgs(1);
        option.setRequired(true);
        Option option2 = new Option("o", "output directory");
        option2.setArgs(1);
        option2.setRequired(true);
        Option option3 = new Option("t", "number of parallel threads");
        option3.setArgs(1);
        Option option4 = new Option("l", "returned triple limit");
        option4.setArgs(1);
        Option option5 = new Option("h", "print help");
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        options.addOption(option5);
        options.addOption(option4);
        BasicParser basicParser = new BasicParser();
        CommandLine commandLine = null;
        try {
            commandLine = basicParser.parse(options, stringArray);
        }
        catch (ParseException parseException) {
            System.err.println("***ERROR: " + parseException.getClass() + ": " + parseException.getMessage());
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        if (commandLine.hasOption("h")) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("parameters:", options);
            return;
        }
        String string = commandLine.getOptionValue("e");
        String string2 = commandLine.getOptionValue("o");
        new URL(string);
        File file = new File(string2);
        int n = 1;
        if (!file.exists()) {
            file.mkdir();
        }
        if (commandLine.hasOption("t")) {
            n = Integer.parseInt(commandLine.getOptionValue("t"));
        }
        int n2 = 5000;
        String string3 = commandLine.getOptionValue("l");
        if (string3 != null) {
            n2 = Integer.parseInt(string3);
        }
        String string4 = "t" + n + "l" + n2 + "e" + string;
        System.out.println("priming benchmark");
        BenchPrime benchPrime = new BenchPrime();
        benchPrime.bench(string, file, n, n2 / 2);
        Map<Node, Integer> map = benchPrime.getClasses();
        Map<Node, Integer> map2 = benchPrime.getOutlinks();
        Map<Node, Integer> map3 = benchPrime.getKeywords();
        Map<Node, Integer> map4 = benchPrime.getInstances();
        System.out.println("classes");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/classes.rq"));
        PrintWriter printWriter2 = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/classes.uris"));
        ConcurrentLinkedQueue<Query> concurrentLinkedQueue = new ConcurrentLinkedQueue<Query>();
        for (Node object22 : map.keySet()) {
            list = new Query();
            ((Query)((Object)list)).addRestriction(RDF.TYPE, object22);
            ((Query)((Object)list)).setLimit(n2);
            concurrentLinkedQueue.add((Query)((Object)list));
            printWriter.println(((Query)((Object)list)).toSparql());
            printWriter2.println(string + "?query=" + URLEncoder.encode(((Query)((Object)list)).toSparql(), "utf-8"));
        }
        printWriter.close();
        printWriter2.close();
        BenchQuery benchQuery = new BenchQuery();
        list = benchQuery.bench(string, file, concurrentLinkedQueue, n, n2);
        printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/classes.dat"));
        printWriter.println("#" + string4);
        printWriter.println("# ms   no results   results/sec");
        for (Long[] longArray : list) {
            printWriter.print(longArray[0]);
            printWriter.print("\t");
            printWriter.print(longArray[1]);
            printWriter.print("\t");
            printWriter.println(longArray[1] * 1000L / longArray[0]);
        }
        printWriter.close();
        System.out.println("instances");
        printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/instances.rq"));
        printWriter2 = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/instances.uris"));
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        for (Node node : map4.keySet()) {
            Query query = new Query(node);
            query.setLimit(n2);
            concurrentLinkedQueue.add(query);
            printWriter.println(query.toSparql());
            printWriter2.println(string + "?query=" + URLEncoder.encode(query.toSparql(), "utf-8"));
        }
        printWriter.close();
        printWriter2.close();
        BenchQuery benchQuery2 = new BenchQuery();
        list = benchQuery2.bench(string, file, concurrentLinkedQueue, n, n2);
        printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/instances.dat"));
        printWriter.println("#" + string4);
        printWriter.println("# ms   no results");
        for (Long[] longArray : list) {
            printWriter.print(longArray[0]);
            printWriter.print("\t");
            printWriter.println(longArray[1]);
        }
        printWriter.close();
        System.out.println("keywords");
        printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/keywords.rq"));
        printWriter2 = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/keywords.uris"));
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        for (Node node : map3.keySet()) {
            Query query = new Query(((Object)node).toString());
            query.setLimit(n2);
            concurrentLinkedQueue.add(query);
            printWriter.println(query.toSparql());
            printWriter2.println(string + "?query=" + URLEncoder.encode(query.toSparql(), "utf-8"));
        }
        printWriter.close();
        printWriter2.close();
        BenchQuery benchQuery3 = new BenchQuery();
        list = benchQuery3.bench(string, file, concurrentLinkedQueue, n, n2);
        printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/keywords.dat"));
        printWriter.println("#" + string4);
        printWriter.println("# ms   no results");
        for (Long[] longArray : list) {
            printWriter.print(longArray[0]);
            printWriter.print("\t");
            printWriter.println(longArray[1]);
        }
        printWriter.close();
        System.out.println("outlinks");
        printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/outlinks.rq"));
        printWriter2 = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/outlinks.uris"));
        concurrentLinkedQueue = new ConcurrentLinkedQueue();
        for (Node node : map2.keySet()) {
            Query query = new Query();
            query.addOutlink((Resource)node);
            query.setLimit(n2);
            concurrentLinkedQueue.add(query);
            printWriter.println(query.toSparql());
            printWriter2.println(string + "?query=" + URLEncoder.encode(query.toSparql(), "utf-8"));
        }
        printWriter.close();
        printWriter2.close();
        BenchQuery benchQuery4 = new BenchQuery();
        list = benchQuery4.bench(string, file, concurrentLinkedQueue, n, n2);
        printWriter = new PrintWriter(new FileOutputStream(file.getAbsolutePath() + "/outlinks.dat"));
        printWriter.println("#" + string4);
        printWriter.println("# ms   no results");
        for (Long[] longArray : list) {
            printWriter.print(longArray[0]);
            printWriter.print("\t");
            printWriter.println(longArray[1]);
        }
        printWriter.close();
    }
}

