/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.clean;

import java.io.PrintStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.DateTimeLiteral;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

public class Cleaner {
    static SimpleDateFormat _iso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    static SimpleDateFormat[] _formats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ"), new SimpleDateFormat("dd-MMM-yy"), new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss"), new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z"), new SimpleDateFormat("MM/dd/yy")};

    public static void clean(Iterator<Node[]> iterator, PrintStream printStream, int n, boolean bl) {
        int n2 = 0;
        long l = 0L;
        while (iterator.hasNext()) {
            boolean bl2 = true;
            Node[] nodeArray = iterator.next();
            ++l;
            if (n != -1 && n != nodeArray.length) {
                System.err.println(l + ": doesn't have " + n + " elements but " + nodeArray.length);
                ++n2;
                continue;
            }
            Node[] nodeArray2 = new Node[nodeArray.length];
            for (int i = 0; i < nodeArray.length; ++i) {
                try {
                    nodeArray2[i] = Cleaner.clean(nodeArray[i], bl);
                    continue;
                }
                catch (Exception exception) {
                    ++n2;
                    bl2 = false;
                    System.err.println(l + ": cannot parse entry " + nodeArray[i] + " " + exception.getMessage());
                }
            }
            if (!bl2) continue;
            for (Node node : nodeArray2) {
                printStream.print(node.toN3() + " ");
            }
            printStream.println(".");
        }
        System.err.println("Processed  " + l + " statements");
        System.err.println("Dropped " + n2 + " statements");
    }

    public static Node clean(Node node, boolean bl) throws URISyntaxException, MalformedURLException {
        if (node instanceof Resource) {
            return new Resource(Cleaner.normaliseURI(((Object)node).toString()));
        }
        if (node instanceof Literal) {
            Literal literal = (Literal)node;
            String string = Cleaner.removeControlChars(literal.toString());
            string = Cleaner.stripHTML(string);
            if ((string = string.trim()).length() <= 0) {
                throw new URISyntaxException("", "dropping emtpy literals");
            }
            string = Literal.escapeForNx(string);
            if (literal.getDatatype() == null && literal.getLanguageTag() == null) {
                return Cleaner.normaliseLiteral(new Literal(string), bl);
            }
            if (literal.getDatatype() != null && literal.getLanguageTag() != null) {
                return new Literal(string, literal.getLanguageTag(), literal.getDatatype());
            }
            if (literal.getDatatype() != null) {
                return new Literal(string, literal.getDatatype());
            }
            return new Literal(string, literal.getLanguageTag());
        }
        return node;
    }

    public static Literal normaliseLiteral(Literal literal, boolean bl) throws URISyntaxException {
        Literal literal2;
        block18: {
            if (literal.getLanguageTag() != null || literal.getDatatype() != null) {
                String string = literal.getData().trim();
                Literal literal3 = null;
                literal3 = literal.getLanguageTag() != null ? new Literal(string, literal.getLanguageTag()) : new Literal(string, literal.getDatatype());
                return literal3;
            }
            if (!bl) {
                String string = literal.getData().trim();
                Literal literal4 = null;
                literal4 = literal.getLanguageTag() != null ? new Literal(string, literal.getLanguageTag()) : new Literal(string, literal.getDatatype());
                return literal4;
            }
            literal2 = null;
            String string = literal.getData().trim();
            Pattern pattern = Pattern.compile("^[-+]?[0-9]*.?[0-9]+$");
            if (pattern.matcher(string).matches()) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                try {
                    Number number = numberFormat.parse(string);
                    if (number instanceof Integer || number instanceof BigInteger || number instanceof Short || number instanceof Long || number instanceof Byte) {
                        literal2 = new Literal(number.toString(), Literal.DECIMAL);
                        break block18;
                    }
                    if (number instanceof Float) {
                        literal2 = new Literal(number.toString(), Literal.FLOAT);
                        break block18;
                    }
                    if (number instanceof Double) {
                        literal2 = new Literal(number.toString(), Literal.DOUBLE);
                        break block18;
                    }
                    throw new URISyntaxException("", "dropping bogus number literal");
                }
                catch (java.text.ParseException parseException) {
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                Date date = null;
                try {
                    date = DateTimeLiteral.parseISO8601(string);
                    literal2 = new Literal(string, Literal.DATETIME);
                    if (literal2 != null) {
                        return literal2;
                    }
                }
                catch (ParseException parseException) {
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                for (SimpleDateFormat simpleDateFormat : _formats) {
                    try {
                        date = simpleDateFormat.parse(string);
                        literal2 = new Literal(_iso.format(date), Literal.DATETIME);
                        if (literal2 == null) continue;
                        break;
                    }
                    catch (java.text.ParseException parseException) {
                        // empty catch block
                    }
                }
            }
        }
        if (literal2 != null) {
            return literal2;
        }
        return literal;
    }

    public static String normaliseURI(String string) throws URISyntaxException, MalformedURLException {
        URI uRI = new URI(string.replaceAll(" ", "%20"));
        if (!(uRI = uRI.normalize()).isOpaque()) {
            int n;
            String string2;
            String string3;
            String string4 = uRI.getScheme();
            if (string4 == null) {
                throw new URISyntaxException(string, "dropping uris without scheme");
            }
            string4 = string4.toLowerCase();
            if (string4.startsWith("http")) {
                uRI.toURL();
            }
            if ((string3 = uRI.getPath()) != null) {
                if (string3.equals("")) {
                    string3 = "/";
                } else if (string3.endsWith("/index.html") || string3.endsWith("/index.htm") || string3.endsWith("/index.asp") || string3.toLowerCase().endsWith("/default.asp") || string3.toLowerCase().endsWith("/default.aspx") || string3.endsWith("/index.jsp") || string3.endsWith("/index.php")) {
                    string3 = string3.substring(0, string3.lastIndexOf(47) + 1);
                }
            }
            if ((string2 = uRI.getHost()) != null) {
                string2 = string2.toLowerCase();
            }
            if ((n = uRI.getPort()) == 80) {
                n = -1;
            }
            URI uRI2 = new URI(string4, uRI.getUserInfo(), string2, n, string3, uRI.getQuery(), uRI.getFragment());
            return uRI2.toString();
        }
        String string5 = uRI.getScheme();
        System.out.println("schem" + string5);
        if (string5 == null) {
            throw new URISyntaxException("", "dropping uris without scheme");
        }
        return string;
    }

    private static String removeControlChars(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = c;
            if (c2 >= '\u0000' && c2 <= '\u001f') {
                stringBuffer.append(" ");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String stripHTML(String string) {
        return string.replaceAll("\\<.*?\\>", "");
    }
}

