/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.benchmark;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Variable;

public class Query {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String TAB = "\t";
    public static final Resource KEYWORD = new Resource("KEYWORD");
    Node _focus;
    int _var = 0;
    List<Node[]> _where = new ArrayList<Node[]>();
    public static final int KW_LIMIT = 50;
    public static final int QUAD_LIMIT = 5000;
    int _limit = 5000;

    public Query() {
        this._focus = new Variable("s" + this._var);
    }

    public Query(Node node) {
        this._focus = node;
    }

    public Query(String string) {
        this();
        Node[] nodeArray = new Node[]{this._focus, KEYWORD, new Literal(string)};
        this._where.add(nodeArray);
    }

    public void setLimit(int n) {
        this._limit = n;
    }

    public Node getFocus() {
        return this._focus;
    }

    public void addRestriction(Resource resource, Node node) {
        Node[] nodeArray = new Node[]{this._focus, resource, node};
        this._where.add(nodeArray);
    }

    public void addOutlink(Resource resource) {
        Node[] nodeArray = new Node[3];
        nodeArray[0] = this._focus;
        nodeArray[1] = resource;
        ++this._var;
        nodeArray[2] = new Variable("s" + this._var);
        this._focus = nodeArray[2];
        this._where.add(nodeArray);
    }

    public List<Node[]> getWhere() {
        return this._where;
    }

    public String toSparql() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this._focus.toN3();
        if (this._focus instanceof BNode) {
            string = "<" + string + ">";
        }
        stringBuffer.append("PREFIX yars2: <http://sw.deri.org/2006/07/yars2/> ");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("CONSTRUCT { GRAPH ?c { ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(new Variable("p").toN3());
        stringBuffer.append(" ");
        stringBuffer.append(new Variable("o").toN3());
        stringBuffer.append(" . } }");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("WHERE {");
        stringBuffer.append(NEWLINE);
        for (Node[] nodeArray : this._where) {
            stringBuffer.append(TAB);
            if (((Object)nodeArray[1]).equals(KEYWORD)) {
                if (!(this._focus instanceof Variable) && this._var > 0 || this._focus instanceof Variable && this._var > 1) {
                    stringBuffer.append(nodeArray[0].toN3());
                    stringBuffer.append(" ");
                    stringBuffer.append(new Variable("pkw").toN3());
                    stringBuffer.append(" ");
                    stringBuffer.append(new Variable("okw").toN3());
                    stringBuffer.append(" .");
                    stringBuffer.append(NEWLINE);
                    stringBuffer.append(TAB);
                }
                stringBuffer.append("FILTER yars2:keyword(");
                stringBuffer.append(nodeArray[0].toN3());
                stringBuffer.append(", ");
                stringBuffer.append(nodeArray[2].toN3());
                stringBuffer.append(", ");
                stringBuffer.append(50);
                stringBuffer.append(")");
                stringBuffer.append(NEWLINE);
                continue;
            }
            for (Node node : nodeArray) {
                String string2 = node.toN3();
                if (node instanceof BNode) {
                    string2 = "<" + string2 + ">";
                }
                stringBuffer.append(string2);
                stringBuffer.append(" ");
            }
            stringBuffer.append(".");
            stringBuffer.append(NEWLINE);
        }
        stringBuffer.append(TAB);
        stringBuffer.append("GRAPH ?c { ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(new Variable("p").toN3());
        stringBuffer.append(" ");
        stringBuffer.append(new Variable("o").toN3());
        stringBuffer.append(" . }");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("}");
        stringBuffer.append(NEWLINE);
        stringBuffer.append("LIMIT ");
        stringBuffer.append(this._limit);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.toSparql().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Query) {
            return ((Query)object).toSparql().equals(this.toSparql());
        }
        return false;
    }
}

