/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.benchmark;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.semanticweb.yars.nx.benchmark.CallbackHook;
import org.semanticweb.yars.nx.benchmark.Query;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;

class LookupThread
extends Thread {
    String _endpoint;
    Queue<Query> _q;
    long _elapsed = 0L;
    int _errors = 0;
    CallbackHook _h;
    int _limit = 0;
    List<Long[]> _stats;

    public LookupThread(String string, Queue<Query> queue, int n) {
        this._endpoint = string;
        this._q = queue;
        this._limit = n;
        this._h = new CallbackHook();
        this._stats = new ArrayList<Long[]>();
    }

    @Override
    public void run() {
        long l;
        long l2 = System.currentTimeMillis();
        Query query = null;
        while ((query = this._q.poll()) != null) {
            l = System.currentTimeMillis();
            long l3 = this._h.size();
            try {
                URL uRL = new URL(this._endpoint + "?query=" + URLEncoder.encode(query.toSparql(), "utf-8"));
                System.out.print(".");
                try {
                    NxParser nxParser = new NxParser(uRL, (Callback)this._h);
                }
                catch (ParseException parseException) {
                    parseException.printStackTrace();
                    System.err.println("error with query " + query);
                    ++this._errors;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    System.err.println("error with query " + query);
                    ++this._errors;
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            long l4 = System.currentTimeMillis();
            long l5 = this._h.size();
            Long[] longArray = new Long[]{l4 - l, l5 - l3};
            this._stats.add(longArray);
        }
        l = System.currentTimeMillis();
        this._elapsed = l - l2;
        System.out.println();
        System.out.println(this._h.size() + " in " + this._elapsed + " ms, " + this._errors + " exceptions");
    }

    public int size() {
        return this._h.size();
    }

    public long getTime() {
        return this._elapsed;
    }

    public long getExceptions() {
        return this._errors;
    }

    public List<Long[]> getStats() {
        return this._stats;
    }
}

