/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.benchmark;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.benchmark.CallbackContentHook;
import org.semanticweb.yars.nx.benchmark.Query;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.NxParser;
import org.semanticweb.yars.nx.parser.ParseException;

class ContentLookupThread
extends Thread {
    String _endpoint;
    long _elapsed = 0L;
    int _errors = 0;
    CallbackContentHook _h;
    int _limit;

    public ContentLookupThread(String string, int n) {
        this._endpoint = string;
        this._limit = n;
        this._h = new CallbackContentHook();
    }

    @Override
    public void run() {
        long l = System.currentTimeMillis();
        Object var3_2 = null;
        try {
            Query query = new Query(new Variable("s"));
            query.setLimit(this._limit);
            URL uRL = new URL(this._endpoint + "?query=" + URLEncoder.encode(query.toSparql(), "utf-8"));
            System.out.print(".");
            try {
                NxParser nxParser = new NxParser(uRL, (Callback)this._h);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                System.err.println("parse error " + parseException.getMessage());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            ++this._errors;
        }
        long l2 = System.currentTimeMillis();
        this._elapsed = l2 - l;
        System.out.println();
        System.out.println(this._h.size() + " in " + this._elapsed + " ms, " + this._errors + " exceptions");
    }

    public int size() {
        return this._h.size();
    }

    public long getTime() {
        return this._elapsed;
    }

    public long getExceptions() {
        return this._errors;
    }

    public Map<Node, Integer> getClasses() {
        return this._h.getClasses();
    }

    public Map<Node, Integer> getOutlinks() {
        return this._h.getOutlinks();
    }

    public Map<Node, Integer> getKeywords() {
        return this._h.getKeywords();
    }

    public Map<Node, Integer> getInstances() {
        return this._h.getInstances();
    }

    public Map<Node[], Integer> getFacets() {
        return this._h.getFacets();
    }
}

