/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;

public class Variable
implements Node,
Serializable {
    public static final long serialVersionUID = 1L;
    private String _data;
    private boolean _isExistential = false;
    public static final String JOIN_CONST_PREFIX = "y2joinvar:";

    public Variable(String string) {
        this._data = string;
    }

    @Override
    public String toString() {
        return this._data;
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof Variable) {
            return this._data.compareTo(object.toString());
        }
        return -1;
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object instanceof Variable && ((Variable)object)._data.equals(this._data);
    }

    @Override
    public String toN3() {
        return "?" + this._data;
    }

    public void setExistential(boolean bl) {
        this._isExistential = bl;
    }

    public boolean isExistential() {
        return this._isExistential;
    }

    @Override
    public int hashCode() {
        return this._data.hashCode();
    }

    public Literal toJoinLiteral() {
        return new Literal(JOIN_CONST_PREFIX + this.toN3());
    }

    public static Variable fromJoinLiteral(Literal literal) {
        if (Variable.isJoinLiteral(literal)) {
            return new Variable(literal.toString().substring(JOIN_CONST_PREFIX.length() + 1));
        }
        return null;
    }

    public static boolean isJoinLiteral(Literal literal) {
        return literal.toString().startsWith(JOIN_CONST_PREFIX);
    }

    public static boolean isJoinLiteral(Node node) {
        return node instanceof Literal && ((Literal)node).toString().startsWith(JOIN_CONST_PREFIX);
    }
}

