/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Unbound;

public class Resource
implements Node,
Serializable {
    protected String _data;
    protected transient int _hashcode = 0;
    public static final long serialVersionUID = 1L;

    public Resource() {
        this._data = null;
    }

    public Resource(String string) {
        this._data = "<" + string + ">";
        this._hashcode = this._data.hashCode();
    }

    public String getHost() throws URISyntaxException {
        URI uRI = new URI(this.toString());
        return uRI.getHost();
    }

    @Override
    public int hashCode() {
        return this._hashcode;
    }

    @Override
    public String toString() {
        return Literal.unescape(this._data.substring(1, this._data.length() - 1));
    }

    @Override
    public String toN3() {
        return this._data;
    }

    @Override
    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return this._data.compareTo(resource._data);
        }
        if (object instanceof BNode) {
            return -1073741824;
        }
        if (object instanceof Literal) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof Unbound) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type Resource but " + object.getClass().getName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return resource._hashcode == this._hashcode && (resource._data == this._data || resource._data.equals(this._data));
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (!this._data.startsWith("<") || !this._data.endsWith(">")) {
            this._data = "<" + this._data + ">";
        }
        this._hashcode = this._data.hashCode();
    }
}

