/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Triple;

public class Quad
extends Triple
implements Serializable {
    private Node _context;
    public static final Resource CONTEXT = new Resource("http://sw.deri.org/2004/06/yars#context");
    public static final long serialVersionUID = 1L;

    public Quad(Node node, Node node2, Node node3, Node node4) {
        super(node, node2, node3);
        this._context = node4;
    }

    public Quad(Triple triple, Node node) {
        super(triple);
        this._context = node;
    }

    public Quad(Quad quad) {
        super(quad);
        this._context = quad.getContext();
    }

    public static Quad fromArray(Node[] nodeArray) {
        if (nodeArray.length != 4) {
            return null;
        }
        return new Quad(nodeArray[0], nodeArray[1], nodeArray[2], nodeArray[3]);
    }

    @Override
    public Node[] toArray() {
        Node[] nodeArray = new Node[]{this.getSubject(), this.getPredicate(), this.getObject(), this.getContext()};
        return nodeArray;
    }

    public Node getContext() {
        return this._context;
    }

    public void setContext(Resource resource) {
        this._context = resource;
    }

    @Override
    public String toString() {
        return this.toN3();
    }

    @Override
    public String toN3() {
        if (this._context == null) {
            return super.toN3();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._sub.toN3());
        stringBuffer.append(" ");
        stringBuffer.append(this._pred.toN3());
        stringBuffer.append(" ");
        stringBuffer.append(this._obj.toN3());
        stringBuffer.append(" ");
        stringBuffer.append(this._context.toN3());
        stringBuffer.append(" ");
        stringBuffer.append(".");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2 = bl = object != null && object instanceof Quad;
        if (bl) {
            Quad quad = (Quad)object;
            bl &= ((Object)quad._sub).equals(this._sub) && ((Object)quad._pred).equals(this._pred) && ((Object)quad._obj).equals(this._obj) && ((Object)quad._context).equals(this._context);
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.toN3().hashCode();
    }
}

