/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.Serializable;
import java.util.Comparator;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;

public class NodeComparator
implements Comparator<Node[]>,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean _variableLength = true;
    private int[] _order = null;
    private int _n = Integer.MAX_VALUE;
    public static final NodeComparator NC_VAR = new NodeComparator(true);
    public static final NodeComparator NC = new NodeComparator(false);

    public NodeComparator(boolean bl) {
        this._variableLength = bl;
    }

    public NodeComparator(int n) {
        this._n = n;
    }

    public NodeComparator(int[] nArray) {
        this._order = nArray;
    }

    public NodeComparator() {
    }

    @Override
    public int compare(Node[] nodeArray, Node[] nodeArray2) {
        int n;
        if (!this._variableLength && (n = nodeArray2.length - nodeArray.length) != 0) {
            return n;
        }
        for (n = 0; n < Math.min(Math.min(nodeArray.length, nodeArray2.length), this._n); ++n) {
            int n2;
            if (this._order != null) {
                if (this._order.length == n) {
                    return 0;
                }
                n2 = this._order[n];
                if (n2 >= nodeArray.length || n2 >= nodeArray2.length) {
                    System.err.println("Cannot compare " + Nodes.toN3(nodeArray) + " with " + Nodes.toN3(nodeArray2) + " for order " + this._order);
                    return Integer.MIN_VALUE;
                }
                int n3 = nodeArray[n2].compareTo(nodeArray2[n2]);
                if (n3 == 0) continue;
                return n3;
            }
            n2 = nodeArray[n].compareTo(nodeArray2[n]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public boolean equals(Node[] nodeArray, Node[] nodeArray2) {
        int n;
        if (!this._variableLength && (n = nodeArray2.length - nodeArray.length) != 0) {
            return false;
        }
        for (n = 0; n < Math.min(Math.min(nodeArray.length, nodeArray2.length), this._n); ++n) {
            if (this._order != null) {
                if (this._order.length == n) {
                    return true;
                }
                int n2 = this._order[n];
                if (n2 >= nodeArray.length || n2 >= nodeArray2.length) {
                    System.err.println("Cannot compare " + Nodes.toN3(nodeArray) + " with " + Nodes.toN3(nodeArray2) + " for order " + this._order);
                    return false;
                }
                if (((Object)nodeArray[n2]).equals(nodeArray2[n2])) continue;
                return false;
            }
            if (((Object)nodeArray[n]).equals(nodeArray2[n])) continue;
            return false;
        }
        return true;
    }
}

