/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;

public class Literal
implements Node,
Serializable {
    protected String _data;
    protected String _lang;
    protected Resource _dt;
    protected transient int _hashcode = 0;
    public static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    public static final Resource STRING = new Resource("http://www.w3.org/2001/XMLSchema#string");
    public static final Resource BOOLEAN = new Resource("http://www.w3.org/2001/XMLSchema#boolean");
    public static final Resource FLOAT = new Resource("http://www.w3.org/2001/XMLSchema#float");
    public static final Resource DECIMAL = new Resource("http://www.w3.org/2001/XMLSchema#decimal");
    public static final Resource DOUBLE = new Resource("http://www.w3.org/2001/XMLSchema#double");
    public static final Resource DATETIME = new Resource("http://www.w3.org/2001/XMLSchema#dateTime");
    public static final long serialVersionUID = 1L;

    public Literal(String string) {
        this(string, null, null);
    }

    public Literal(String string, String string2) {
        this(string, string2, null);
    }

    public Literal(String string, Resource resource) {
        this(string, null, resource);
    }

    public Literal(String string, String string2, Resource resource) {
        this._data = string;
        this._lang = string2;
        this._dt = resource;
        this._hashcode = this.getHashCode();
    }

    public String getData() {
        return this._data;
    }

    public String getMarkupEscapedData() {
        return Literal.escapeForMarkup(this._data);
    }

    public String getUnescapedData() {
        return Literal.unescape(this._data);
    }

    public String getLanguageTag() {
        return this._lang;
    }

    public boolean isConstant() {
        return true;
    }

    public Resource getDatatype() {
        return this._dt;
    }

    @Override
    public String toString() {
        return Literal.unescape(this._data);
    }

    @Override
    public String toN3() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(this._data);
        stringBuffer.append("\"");
        if (this._lang != null) {
            stringBuffer.append("@");
            stringBuffer.append(this._lang);
        } else if (this._dt != null) {
            stringBuffer.append("^^");
            stringBuffer.append(this._dt.toN3());
        }
        return stringBuffer.toString();
    }

    @Override
    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            int n = this._data.compareTo(literal._data);
            if (n == 0) {
                if (this._lang != null && literal._lang != null) {
                    return this._lang.compareTo(literal._lang);
                }
                if (this._dt != null && literal._dt != null) {
                    return this._dt.compareTo(literal._dt);
                }
                if (this._lang != null && literal._dt != null) {
                    return -19;
                }
                if (literal._lang != null && this._dt != null) {
                    return 19;
                }
            }
            return n;
        }
        if (object instanceof Resource) {
            return -715827882;
        }
        if (object instanceof BNode) {
            return -1073741824;
        }
        if (object instanceof Unbound) {
            return Integer.MIN_VALUE;
        }
        throw new ClassCastException("parameter is not of type Literal but " + object.getClass().getName());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Literal) {
            Literal literal = (Literal)object;
            return !(literal._hashcode != this._hashcode || literal._data == null ^ this._data == null || literal._dt == null ^ this._dt == null || literal._lang == null ^ this._lang == null || literal._data != this._data && !literal._data.equals(this._data) || literal._lang != this._lang && !literal._lang.equals(this._lang) || literal._dt != this._dt && !literal._dt.equals(this._dt));
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._hashcode;
    }

    private int getHashCode() {
        return this.toN3().hashCode();
    }

    public static String escapeForNx(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c;
            char c2 = c = string.charAt(i);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                default: {
                    if (c2 >= '\u0000' && c2 <= '\b' || c2 == '\u000b' || c2 == '\f' || c2 >= '\u000e' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\uffff') {
                        stringBuffer.append("\\u");
                        stringBuffer.append(Literal.toHexString(c2, 4));
                        continue block7;
                    }
                    if (c2 >= '\u10000' && c2 <= '\u10ffff') {
                        stringBuffer.append("\\U");
                        stringBuffer.append(Literal.toHexString(c2, 8));
                        continue block7;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String escapeForMarkup(String string) {
        String string2 = Literal.unescape(string);
        StringBuffer stringBuffer = new StringBuffer();
        block8: for (int i = 0; i < string2.length(); ++i) {
            char c;
            char c2 = c = string2.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("&#039;");
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append("&#092;");
                    continue block8;
                }
                default: {
                    if (c2 >= '\u0000' && c2 <= '\b' || c2 == '\u000b' || c2 == '\f' || c2 >= '\u000e' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\uffff') {
                        stringBuffer.append("&#x");
                        stringBuffer.append(Literal.toHexString(c2, 4));
                        stringBuffer.append(";");
                        continue block8;
                    }
                    if (c2 >= '\u10000' && c2 <= '\u10ffff') {
                        stringBuffer.append("&#x");
                        stringBuffer.append(Literal.toHexString(c2, 8));
                        stringBuffer.append(";");
                        continue block8;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static String toHexString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(n2);
        String string = Integer.toHexString(n).toUpperCase();
        int n3 = n2 - string.length();
        for (int i = 0; i < n3; ++i) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String unescape(String string) {
        Literal.cleanSlashes(string);
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        StringBuffer stringBuffer2 = new StringBuffer(4);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl2 && stringBuffer2.length() < 4) {
                stringBuffer2.append(c);
                if (stringBuffer2.length() != 4) continue;
                try {
                    int n2 = Integer.parseInt(stringBuffer2.toString(), 16);
                    stringBuffer.append((char)n2);
                    stringBuffer2 = new StringBuffer(4);
                    bl2 = false;
                    bl = false;
                }
                catch (NumberFormatException numberFormatException) {
                    stringBuffer.append(stringBuffer2.toString());
                }
                continue;
            }
            if (bl) {
                bl = false;
                switch (c) {
                    case '\\': {
                        stringBuffer.append('\\');
                        break;
                    }
                    case '\'': {
                        stringBuffer.append('\'');
                        break;
                    }
                    case '\"': {
                        stringBuffer.append('\"');
                        break;
                    }
                    case 'r': {
                        stringBuffer.append('\r');
                        break;
                    }
                    case 'f': {
                        stringBuffer.append('\f');
                        break;
                    }
                    case 't': {
                        stringBuffer.append('\t');
                        break;
                    }
                    case 'n': {
                        stringBuffer.append('\n');
                        break;
                    }
                    case 'b': {
                        stringBuffer.append('\b');
                        break;
                    }
                    case 'u': {
                        bl2 = true;
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                        break;
                    }
                }
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuffer.append(c);
        }
        if (bl) {
            stringBuffer.append('\\');
        }
        return stringBuffer.toString();
    }

    private static String cleanSlashes(String string) {
        while (string.indexOf("\\\\") != -1) {
            string = string.replaceAll("\\\\\\\\", "\\\\");
        }
        return string;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this._hashcode = this.getHashCode();
    }
}

