/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

public class DateTimeLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    public static final Resource DATETIME = new Resource("http://www.w3.org/2001/XMLSchema#dateTime");
    Date _date;

    public DateTimeLiteral(String string) throws ParseException, NumberFormatException {
        super(string);
        this._dt = DATETIME;
        this._date = DateTimeLiteral.parseISO8601(string);
    }

    public Date getDate() {
        return this._date;
    }

    public int compareTo(DateTimeLiteral dateTimeLiteral) {
        return this.toString().compareTo(dateTimeLiteral.toString());
    }

    public static Date parseISO8601(String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-T:.Z+", true);
        if (stringTokenizer == null || stringTokenizer.countTokens() == 0) {
            throw new ParseException("parseISO8601: Cannot parse '" + string + "'");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Etc/UTC"));
        calendar.clear();
        try {
            String string2 = stringTokenizer.nextToken();
            try {
                Integer n = Integer.parseInt(string2);
                calendar.set(1, n);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("parseISO8601: Cannot parse '" + string + "'");
            }
            if (!stringTokenizer.hasMoreTokens()) {
                return calendar.getTime();
            }
            if (!stringTokenizer.nextToken().equals("-")) {
                return calendar.getTime();
            }
            calendar.set(2, Integer.parseInt(stringTokenizer.nextToken()) - 1);
            if (!stringTokenizer.hasMoreTokens()) {
                return calendar.getTime();
            }
            if (!stringTokenizer.nextToken().equals("-")) {
                return calendar.getTime();
            }
            calendar.set(5, Integer.parseInt(stringTokenizer.nextToken()));
            if (!stringTokenizer.hasMoreTokens()) {
                return calendar.getTime();
            }
            if (stringTokenizer.nextToken().equals("T")) {
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (stringTokenizer.nextToken().equals(":")) {
                    int n5;
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals(":")) {
                        n3 = Integer.parseInt(stringTokenizer.nextToken());
                        string3 = stringTokenizer.nextToken();
                        if (string3.equals(".")) {
                            n4 = Integer.parseInt(stringTokenizer.nextToken());
                            string3 = stringTokenizer.nextToken();
                        }
                    }
                    if (string3.equals("Z")) {
                        n5 = 0;
                    } else {
                        int n6 = 0;
                        if (string3.equals("+")) {
                            n6 = 1;
                        } else if (string3.equals("-")) {
                            n6 = -1;
                        } else {
                            return calendar.getTime();
                        }
                        n5 = n6 * Integer.parseInt(stringTokenizer.nextToken()) * 10 * 3600;
                    }
                    calendar.set(15, n5);
                }
                calendar.set(11, n);
                calendar.set(12, n2);
                calendar.set(13, n3);
                calendar.set(14, n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!calendar.isSet(1)) {
            throw new ParseException("parseISO8601: Cannot parse '" + string + "'");
        }
        return calendar.getTime();
    }
}

