/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.NumericLiteral;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.parser.ParseException;

public class BooleanLiteral
extends Literal {
    private static final long serialVersionUID = 1L;
    public static final Resource BOOLEAN = new Resource("http://www.w3.org/2001/XMLSchema#boolean");
    public static final BooleanLiteral TRUE = new BooleanLiteral(true);
    public static final BooleanLiteral FALSE = new BooleanLiteral(false);

    private BooleanLiteral(boolean bl) {
        super("");
        this._data = bl ? "true" : "false";
        this._dt = BOOLEAN;
    }

    public boolean toBoolean() {
        return this._data.equals("true");
    }

    public static BooleanLiteral getEffectiveBooleanLit(Literal literal) throws ParseException {
        Resource resource = literal.getDatatype();
        if (literal instanceof BooleanLiteral) {
            return (BooleanLiteral)literal;
        }
        if (resource == null || resource.equals(STRING)) {
            if (literal.getData() == null || literal.getData().length() == 0) {
                return FALSE;
            }
            return TRUE;
        }
        if (resource.equals(BOOLEAN)) {
            if (literal.getData().equals("true")) {
                return TRUE;
            }
            return FALSE;
        }
        if (literal.getData().equals("NaN")) {
            return FALSE;
        }
        NumericLiteral numericLiteral = NumericLiteral.getNumericLiteral(literal);
        Number number = numericLiteral.getNumber();
        if (number == null) {
            throw new IllegalArgumentException("Cannot parse literal " + literal.getData() + " " + literal.getDatatype() + " into a boolean value.");
        }
        if (number.doubleValue() == 0.0) {
            return FALSE;
        }
        return TRUE;
    }

    public static void main(String[] stringArray) {
        Literal literal = new Literal("true", new Resource("http://www.w3.org/2001/XMLSchema#boolean"));
        Literal literal2 = new Literal("true", new Resource("http://www.w3.org/2001/XMLSchema#boolean"));
        System.out.println(literal.equals(literal2));
        BooleanLiteral booleanLiteral = new BooleanLiteral(true);
        BooleanLiteral booleanLiteral2 = new BooleanLiteral(true);
        System.out.println(booleanLiteral.equals(literal2));
        System.out.println(booleanLiteral.equals(booleanLiteral2));
        System.out.println(((Object)literal2).equals(booleanLiteral));
    }
}

