/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;

public class BNode
implements Serializable,
Node {
    public static String PREFIX = "_:";
    protected String _data;
    protected transient int _hashcode = 0;
    public static final long serialVersionUID = 1L;

    public BNode(String string) {
        this._data = PREFIX + string;
        this._hashcode = this._data.hashCode();
    }

    @Override
    public String toString() {
        return Literal.unescape(this._data.substring(PREFIX.length()));
    }

    @Override
    public int hashCode() {
        return this._hashcode;
    }

    @Override
    public String toN3() {
        return this._data;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BNode) {
            BNode bNode = (BNode)object;
            return bNode._hashcode == this._hashcode && (bNode._data == this._data || bNode._data.equals(this._data));
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (object instanceof BNode) {
            BNode bNode = (BNode)object;
            return this._data.compareTo(bNode._data);
        }
        if (object instanceof Resource) {
            return 0x3FFFFFFF;
        }
        if (object instanceof Literal) {
            return Integer.MAX_VALUE;
        }
        if (object instanceof Unbound) {
            return -1073741824;
        }
        throw new ClassCastException("parameter is not of type BNode but " + object.getClass().getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (!this._data.startsWith(PREFIX)) {
            this._data = PREFIX + this._data;
        }
        this._hashcode = this._data.hashCode();
    }
}

