/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.telemetry;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.coode.owlapi.owlxml.renderer.OWLXMLObjectRenderer;
import org.coode.owlapi.owlxml.renderer.OWLXMLWriter;
import org.coode.xml.XMLWriterNamespaceManager;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryObject;
import org.semanticweb.owl.explanation.telemetry.TelemetryReceiver;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryXMLWriter;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTelemetryReceiver
implements TelemetryReceiver {
    private TelemetryXMLWriter xmlWriter;
    private Stack<TelemetryInfo> telemetryNodeStack = new Stack();
    private Stack<Boolean> ignoreNodeStack = new Stack();
    private Set<String> ignoredNodeNames = new HashSet<String>();
    private int depth = 0;
    private Writer baseWriter;

    public XMLTelemetryReceiver() {
        this(XMLTelemetryReceiver.getNextFile("telemetry-", ".xml"));
    }

    private static File getNextFile(String prefix, String suffix) {
        File outputFile;
        int i = 0;
        while ((outputFile = new File(prefix + i + suffix)).exists()) {
            ++i;
        }
        return outputFile;
    }

    public XMLTelemetryReceiver(File outputFile) {
        try {
            XMLWriterNamespaceManager nsm = new XMLWriterNamespaceManager("");
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile), 0xA00000);
            this.baseWriter = new PrintWriter(bw);
            this.xmlWriter = new TelemetryXMLWriter(this.baseWriter, nsm, "");
            this.xmlWriter.startDocument("experiments");
            ++this.depth;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                try {
                    XMLTelemetryReceiver.this.xmlWriter.endDocument();
                    XMLTelemetryReceiver.this.baseWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void addIgnoreName(String name) {
        this.ignoredNodeNames.add(name);
    }

    public void closeOpenTransmissions() {
        while (!this.telemetryNodeStack.isEmpty()) {
            TelemetryInfo info = this.telemetryNodeStack.peek();
            this.endTransmission(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginTransmission(TelemetryInfo info) {
        List<TelemetryTimer> timers = this.pauseRunningTimers();
        try {
            try {
                this.telemetryNodeStack.push(info);
                boolean ignore = false;
                if (!this.ignoreNodeStack.isEmpty()) {
                    ignore = this.ignoreNodeStack.peek();
                }
                if (!ignore) {
                    ignore = this.ignoredNodeNames.contains(info.getName());
                }
                this.ignoreNodeStack.push(ignore);
                if (!ignore) {
                    this.xmlWriter.writeStartElement(info.getName());
                }
                ++this.depth;
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var5_6 = null;
                this.unpauseTimers(timers);
            }
            Object var5_5 = null;
            this.unpauseTimers(timers);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.unpauseTimers(timers);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordMeasurement(TelemetryInfo info, String propertyName, String value) {
        if (propertyName != null && value != null && !this.isIgnoredTransmission()) {
            List<TelemetryTimer> timers = this.pauseRunningTimers();
            try {
                try {
                    this.xmlWriter.writeStartElement("measurement");
                    this.xmlWriter.writeAttribute("name", propertyName);
                    this.xmlWriter.writeAttribute("value", value);
                    this.xmlWriter.writeEndElement();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var7_6 = null;
                    this.unpauseTimers(timers);
                }
                Object var7_5 = null;
                this.unpauseTimers(timers);
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.unpauseTimers(timers);
                throw throwable;
            }
        }
    }

    private boolean isIgnoredTransmission() {
        return !this.ignoreNodeStack.isEmpty() && this.ignoreNodeStack.peek() != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recordException(TelemetryInfo info, Throwable exception) {
        List<TelemetryTimer> pausedTimers = this.pauseRunningTimers();
        try {
            try {
                this.xmlWriter.writeStartElement("exception");
                this.xmlWriter.writeStartElement("class");
                this.xmlWriter.writeTextContent(exception.getClass().getName());
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeStartElement("message");
                this.xmlWriter.writeTextContent(exception.getMessage());
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeStartElement("stacktrace");
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                exception.printStackTrace(pw);
                pw.flush();
                this.xmlWriter.writeTextContent(sw.getBuffer().toString());
                this.xmlWriter.writeEndElement();
                this.xmlWriter.writeEndElement();
            }
            catch (IOException e) {
                e.printStackTrace();
                Object var7_8 = null;
                this.unpauseTimers(pausedTimers);
            }
            Object var7_7 = null;
            this.unpauseTimers(pausedTimers);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.unpauseTimers(pausedTimers);
            throw throwable;
        }
    }

    @Override
    public void recordObject(TelemetryInfo info, String namePrefix, String nameSuffix, Object object) {
        if (!this.isIgnoredTransmission()) {
            List<TelemetryTimer> timers = this.pauseRunningTimers();
            this.serialiseObject(info, namePrefix, object);
            this.unpauseTimers(timers);
        }
    }

    private void serialiseObject(TelemetryInfo info, String namePrefix, Object object) {
        if (!this.isIgnoredTransmission()) {
            try {
                boolean writeAsXML = false;
                this.xmlWriter.writeStartElement("object");
                this.xmlWriter.writeAttribute("name", namePrefix);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                boolean wrapInCDataSection = true;
                if (object instanceof TelemetryObject) {
                    TelemetryObject telemetryObject = (TelemetryObject)object;
                    telemetryObject.serialise(bos);
                    if (!telemetryObject.isSerialisedAsXML()) {
                        wrapInCDataSection = false;
                    } else {
                        wrapInCDataSection = false;
                        writeAsXML = true;
                    }
                } else if (object instanceof OWLAxiom) {
                    OWLAxiom ax = (OWLAxiom)object;
                    OutputStreamWriter osw = new OutputStreamWriter(bos);
                    OWLXMLWriter writer = new OWLXMLWriter((Writer)osw, null);
                    OWLXMLObjectRenderer renderer = new OWLXMLObjectRenderer(writer);
                    ax.accept((OWLObjectVisitor)renderer);
                    osw.flush();
                    wrapInCDataSection = false;
                    writeAsXML = true;
                } else {
                    OutputStreamWriter writer = new OutputStreamWriter(bos);
                    String string = object.toString();
                    writer.write(string);
                    writer.flush();
                }
                if (wrapInCDataSection) {
                    this.xmlWriter.writeCData(bos.toString());
                } else if (writeAsXML) {
                    this.xmlWriter.writeXMLContent(bos.toString());
                } else {
                    this.xmlWriter.writeTextContent(bos.toString());
                }
                this.xmlWriter.writeEndElement();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void recordTiming(TelemetryInfo info, String name, TelemetryTimer telemetryTimer) {
        if (!this.isIgnoredTransmission()) {
            this.recordMeasurement(info, name, Long.toString(telemetryTimer.getEllapsedTime()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endTransmission(TelemetryInfo info) {
        List<TelemetryTimer> timers = this.pauseRunningTimers();
        try {
            block7: {
                try {
                    if (!this.isIgnoredTransmission()) {
                        this.xmlWriter.writeEndElement();
                    }
                    if (!this.telemetryNodeStack.isEmpty()) {
                        this.telemetryNodeStack.pop();
                    }
                    if (!this.ignoreNodeStack.isEmpty()) {
                        this.ignoreNodeStack.pop();
                    }
                    --this.depth;
                    if (this.depth != 0) break block7;
                    this.xmlWriter.endDocument();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Object var5_4 = null;
                    this.unpauseTimers(timers);
                }
            }
            Object var5_3 = null;
            this.unpauseTimers(timers);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.unpauseTimers(timers);
            throw throwable;
        }
    }

    private void unpauseTimers(List<TelemetryTimer> paused) {
        for (TelemetryTimer timer : paused) {
            timer.start();
        }
    }

    private List<TelemetryTimer> pauseRunningTimers() {
        ArrayList<TelemetryTimer> paused = new ArrayList<TelemetryTimer>();
        for (TelemetryInfo i : this.telemetryNodeStack) {
            for (TelemetryTimer timer : i.getTimers()) {
                if (timer == null || !timer.isRunning()) continue;
                timer.stop();
                paused.add(timer);
            }
        }
        return paused;
    }
}

