/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.telemetry;

import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.coode.string.EscapeUtils;
import org.coode.xml.XMLWriter;
import org.coode.xml.XMLWriterNamespaceManager;
import org.coode.xml.XMLWriterPreferences;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class TelemetryXMLWriter
implements XMLWriter {
    private Stack<XMLElement> elementStack;
    protected Writer writer;
    private String encoding = "";
    private String xmlBase;
    private URI xmlBaseURI;
    private XMLWriterNamespaceManager xmlWriterNamespaceManager;
    private Map<String, String> entities;
    private static final int TEXT_CONTENT_WRAP_LIMIT = Integer.MAX_VALUE;
    private boolean preambleWritten;
    private static final String PERCENT_ENTITY = "&#37;";

    public TelemetryXMLWriter(Writer writer, XMLWriterNamespaceManager nsm, String xmlBase) {
        this.writer = writer;
        this.xmlWriterNamespaceManager = nsm;
        this.xmlBase = xmlBase;
        this.xmlBaseURI = URI.create(xmlBase);
        this.elementStack = new Stack();
        this.setupEntities();
    }

    private void setupEntities() {
        ArrayList namespaces = new ArrayList(this.xmlWriterNamespaceManager.getNamespaces());
        Collections.sort(namespaces, new StringLengthOnlyComparator());
        this.entities = new LinkedHashMap<String, String>();
        for (String curNamespace : namespaces) {
            String curPrefix = "";
            curPrefix = this.xmlWriterNamespaceManager.getDefaultNamespace().equals(curNamespace) ? this.xmlWriterNamespaceManager.getDefaultPrefix() : this.xmlWriterNamespaceManager.getPrefixForNamespace(curNamespace);
            if (curPrefix.length() <= 0) continue;
            this.entities.put(curNamespace, "&" + curPrefix + ";");
        }
    }

    private String swapForEntity(String value) {
        for (String curEntity : this.entities.keySet()) {
            String repVal;
            String entityVal = this.entities.get(curEntity);
            if (value.length() <= curEntity.length() || (repVal = value.replace(curEntity, entityVal)).length() >= value.length()) continue;
            return repVal;
        }
        return value;
    }

    public String getDefaultNamespace() {
        return this.xmlWriterNamespaceManager.getDefaultNamespace();
    }

    public String getXMLBase() {
        return this.xmlBase;
    }

    public URI getXMLBaseAsURI() {
        return this.xmlBaseURI;
    }

    public XMLWriterNamespaceManager getNamespacePrefixes() {
        return this.xmlWriterNamespaceManager;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private boolean isValidQName(String name) {
        if (name == null) {
            return false;
        }
        int colonIndex = name.indexOf(":");
        boolean valid = false;
        if (colonIndex == -1) {
            valid = OWL2Datatype.XSD_NCNAME.getPattern().matcher(name).matches();
        } else {
            valid = OWL2Datatype.XSD_NCNAME.getPattern().matcher(name.substring(0, colonIndex - 1)).matches();
            if (valid) {
                valid = OWL2Datatype.XSD_NAME.getPattern().matcher(name.substring(colonIndex + 1)).matches();
            }
        }
        return valid;
    }

    public void setWrapAttributes(boolean b) {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.peek();
            element.setWrapAttributes(b);
        }
    }

    public void writeStartElement(String name) throws IOException {
        XMLElement topElement;
        XMLElement element = new XMLElement(name, this.elementStack.size());
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        this.elementStack.push(element);
    }

    public void writeEndElement() throws IOException {
        if (!this.elementStack.isEmpty()) {
            XMLElement element = this.elementStack.pop();
            element.writeElementEnd();
        }
    }

    public void writeAttribute(String attr, String val) {
        XMLElement element = this.elementStack.peek();
        element.setAttribute(this.xmlWriterNamespaceManager.getQName(attr), val);
    }

    public void writeTextContent(String text) {
        XMLElement element = this.elementStack.peek();
        element.setText(text, false);
    }

    public void writeXMLContent(String text) {
        XMLElement element = this.elementStack.peek();
        element.setXMLContent(text);
    }

    public void writeCData(String data) {
        XMLElement element = this.elementStack.peek();
        element.setText(data, true);
    }

    public void writeComment(String commentText) throws IOException {
        XMLElement topElement;
        XMLElement element = new XMLElement(null, this.elementStack.size());
        element.setText("<!-- " + commentText.replaceAll("--", "&#45;&#45;") + " -->", false);
        if (!this.elementStack.isEmpty() && (topElement = this.elementStack.peek()) != null) {
            topElement.writeElementStart(false);
        }
        if (this.preambleWritten) {
            element.writeElementStart(true);
        } else {
            this.elementStack.push(element);
        }
    }

    private void writeEntities(String rootName) throws IOException {
        this.writer.write("\n\n<!DOCTYPE " + this.xmlWriterNamespaceManager.getQName(rootName) + " [\n");
        for (String entityVal : this.entities.keySet()) {
            String entity = this.entities.get(entityVal);
            entity = entity.substring(1, entity.length() - 1);
            this.writer.write("    <!ENTITY ");
            this.writer.write(entity);
            this.writer.write(" \"");
            entityVal = EscapeUtils.escapeXML((String)entityVal);
            entityVal = entityVal.replace("%", PERCENT_ENTITY);
            this.writer.write(entityVal);
            this.writer.write("\" >\n");
        }
        this.writer.write("]>\n\n\n");
    }

    public void startDocument(String rootElementName) throws IOException {
        String encodingString = "";
        if (this.encoding.length() > 0) {
            encodingString = " encoding=\"" + this.encoding + "\"";
        }
        this.writer.write("<?xml version=\"1.0\"" + encodingString + "?>\n");
        if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
            this.writeEntities(rootElementName);
        }
        this.preambleWritten = true;
        while (!this.elementStack.isEmpty()) {
            this.elementStack.pop().writeElementStart(true);
        }
        this.writeStartElement(rootElementName);
        this.setWrapAttributes(true);
        String defaultNamespace = this.xmlWriterNamespaceManager.getDefaultNamespace();
        if (defaultNamespace.length() > 0) {
            this.writeAttribute("xmlns", defaultNamespace);
        }
        if (this.xmlBase.length() != 0) {
            this.writeAttribute("xml:base", this.xmlBase);
        }
        for (String curPrefix : this.xmlWriterNamespaceManager.getPrefixes()) {
            if (curPrefix.length() <= 0) continue;
            this.writeAttribute("xmlns:" + curPrefix, this.xmlWriterNamespaceManager.getNamespaceForPrefix(curPrefix));
        }
    }

    public void endDocument() throws IOException {
        while (!this.elementStack.isEmpty()) {
            this.writeEndElement();
        }
        this.writer.flush();
    }

    public class XMLElement {
        private String name;
        private Map<String, String> attributes;
        String textContent;
        private boolean cdata = false;
        private boolean startWritten;
        private int indentation;
        private boolean wrapAttributes;
        private boolean escape = true;

        public XMLElement(String name) {
            this(name, 0);
            this.wrapAttributes = false;
        }

        public XMLElement(String name, int indentation) {
            this.name = name;
            this.attributes = new LinkedHashMap<String, String>();
            this.indentation = indentation;
            this.textContent = null;
            this.startWritten = false;
        }

        public void setWrapAttributes(boolean b) {
            this.wrapAttributes = b;
        }

        public void setAttribute(String attribute, String value) {
            this.attributes.put(attribute, value);
        }

        public void setText(String content, boolean cdata) {
            this.textContent = content;
            this.cdata = cdata;
        }

        public void setXMLContent(String content) {
            this.textContent = content;
            this.escape = false;
        }

        public void writeElementStart(boolean close) throws IOException {
            if (!this.startWritten) {
                this.startWritten = true;
                this.insertIndentation();
                if (this.name != null) {
                    TelemetryXMLWriter.this.writer.write(60);
                    TelemetryXMLWriter.this.writer.write(this.name);
                    this.writeAttributes();
                    if (this.textContent != null) {
                        boolean wrap;
                        boolean bl = wrap = this.textContent.length() > Integer.MAX_VALUE;
                        if (wrap) {
                            this.writeNewLine();
                            ++this.indentation;
                            this.insertIndentation();
                        }
                        TelemetryXMLWriter.this.writer.write(62);
                        this.writeTextContent();
                        if (wrap) {
                            --this.indentation;
                        }
                    }
                    if (close) {
                        if (this.textContent != null) {
                            this.writeElementEnd();
                        } else {
                            TelemetryXMLWriter.this.writer.write("/>");
                            this.writeNewLine();
                        }
                    } else if (this.textContent == null) {
                        TelemetryXMLWriter.this.writer.write(62);
                        this.writeNewLine();
                    }
                } else if (this.textContent != null) {
                    TelemetryXMLWriter.this.writer.write("\n\n\n");
                    StringTokenizer tokenizer = new StringTokenizer(this.textContent, "\n", true);
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (!token.equals("\n")) {
                            this.insertIndentation();
                        }
                        TelemetryXMLWriter.this.writer.write(token);
                    }
                    TelemetryXMLWriter.this.writer.write("\n\n");
                }
            }
        }

        public void writeElementEnd() throws IOException {
            if (this.name != null) {
                if (!this.startWritten) {
                    this.writeElementStart(true);
                } else {
                    if (this.textContent == null) {
                        this.insertIndentation();
                    }
                    TelemetryXMLWriter.this.writer.write("</");
                    TelemetryXMLWriter.this.writer.write(this.name);
                    TelemetryXMLWriter.this.writer.write(">");
                    this.writeNewLine();
                }
            }
        }

        private void writeAttribute(String attr, String val) throws IOException {
            TelemetryXMLWriter.this.writer.write(attr);
            TelemetryXMLWriter.this.writer.write(61);
            TelemetryXMLWriter.this.writer.write(34);
            if (XMLWriterPreferences.getInstance().isUseNamespaceEntities()) {
                TelemetryXMLWriter.this.writer.write(TelemetryXMLWriter.this.swapForEntity(EscapeUtils.escapeXML((String)val)));
            } else {
                TelemetryXMLWriter.this.writer.write(EscapeUtils.escapeXML((String)val));
            }
            TelemetryXMLWriter.this.writer.write(34);
        }

        private void writeAttributes() throws IOException {
            Iterator<String> it = this.attributes.keySet().iterator();
            while (it.hasNext()) {
                String attr = it.next();
                String val = this.attributes.get(attr);
                TelemetryXMLWriter.this.writer.write(32);
                this.writeAttribute(attr, val);
                if (!it.hasNext() || !this.wrapAttributes) continue;
                TelemetryXMLWriter.this.writer.write("\n");
                ++this.indentation;
                this.insertIndentation();
                --this.indentation;
            }
        }

        private void writeTextContent() throws IOException {
            if (this.textContent != null) {
                if (!this.cdata) {
                    if (this.escape) {
                        TelemetryXMLWriter.this.writer.write(EscapeUtils.escapeXML((String)this.textContent));
                    } else {
                        TelemetryXMLWriter.this.writer.write(this.textContent);
                    }
                } else {
                    TelemetryXMLWriter.this.writer.write("<![CDATA[");
                    TelemetryXMLWriter.this.writer.write(this.textContent);
                    TelemetryXMLWriter.this.writer.write("]]>");
                }
            }
        }

        private void insertIndentation() throws IOException {
            if (XMLWriterPreferences.getInstance().isIndenting()) {
                for (int i = 0; i < this.indentation * XMLWriterPreferences.getInstance().getIndentSize(); ++i) {
                    TelemetryXMLWriter.this.writer.write(32);
                }
            }
        }

        private void writeNewLine() throws IOException {
            TelemetryXMLWriter.this.writer.write(10);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StringLengthOnlyComparator
    implements Comparator<String> {
        private StringLengthOnlyComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }
    }
}

