/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.setree;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SETreeNode<O> {
    private List<O> elements;
    private SETreeNode<O> parent;
    private List<SETreeNode> children = new ArrayList<SETreeNode>();

    public SETreeNode(List<O> elements) {
        this.elements = elements;
    }

    public List<O> getElements() {
        return this.elements;
    }

    public void addChild(SETreeNode node) {
        this.children.add(node);
        node.parent = this;
    }

    public List<SETreeNode> getChildren() {
        return this.children;
    }

    public int getDepth() {
        SETreeNode<O> current = this.parent;
        int depth = 0;
        while (current != null) {
            current = current.parent;
            ++depth;
        }
        return depth;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        for (O element : this.elements) {
            sb.append(element);
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }
}

