/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.setree;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.NullExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.BlackBoxExplanationGenerator2;
import org.semanticweb.owl.explanation.impl.blackbox.DivideAndConquerContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.blackbox.StructuralTypePriorityExpansionStrategy;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SETreeExplanationGenerator
implements ExplanationGenerator<OWLAxiom> {
    private OWLReasonerFactory reasonerFactory;
    private EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory;
    private Set<OWLAxiom> workingAxioms = new HashSet<OWLAxiom>();
    private Set<OWLAxiom> module = new HashSet<OWLAxiom>();

    public SETreeExplanationGenerator(OWLReasonerFactory reasonerFactory, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory, Set<? extends OWLAxiom> workingAxioms) {
        this.workingAxioms = new HashSet<OWLAxiom>(workingAxioms);
        this.reasonerFactory = reasonerFactory;
        this.entailmentCheckerFactory = entailmentCheckerFactory;
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment) throws ExplanationException {
        return this.getExplanations(entailment, Integer.MAX_VALUE);
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment, int limit) throws ExplanationException {
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        SyntacticLocalityModuleExtractor extractor = new SyntacticLocalityModuleExtractor(manager, null, this.workingAxioms, ModuleType.STAR);
        this.module = extractor.extract(entailment.getSignature());
        BlackBoxExplanationGenerator2<OWLAxiom> gen = new BlackBoxExplanationGenerator2<OWLAxiom>(this.module, this.entailmentCheckerFactory, new StructuralTypePriorityExpansionStrategy(), new DivideAndConquerContractionStrategy(), new NullExplanationProgressMonitor());
        Set<Explanation<OWLAxiom>> expls = gen.getExplanations(entailment, 1);
        Explanation<OWLAxiom> expl = expls.iterator().next();
        HashSet<OWLAxiom> commonAxioms = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : expl.getAxioms()) {
            this.module.remove(ax);
            EntailmentChecker<OWLAxiom> entailmentChecker = this.entailmentCheckerFactory.createEntailementChecker(entailment);
            if (!entailmentChecker.isEntailed(this.module)) {
                commonAxioms.add(ax);
            }
            this.module.add(ax);
        }
        System.out.println("There are " + commonAxioms.size() + " common axioms");
        HashSet commonAxiomsSig = new HashSet();
        for (OWLAxiom ax : commonAxioms) {
            System.out.println("\t" + ax);
            commonAxiomsSig.addAll(ax.getSignature());
        }
        HashSet<OWLAxiom> expansionCandidates = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> directExpansionCandidates = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : this.module) {
            if (commonAxioms.contains(ax)) continue;
            for (OWLEntity ent : ax.getSignature()) {
                if (!commonAxiomsSig.contains(ent)) continue;
                expansionCandidates.add(ax);
                for (OWLEntity entailmentEnt : entailment.getSignature()) {
                    if (!ax.getSignature().contains(entailmentEnt)) continue;
                    directExpansionCandidates.add(ax);
                }
            }
        }
        System.out.println("There are " + directExpansionCandidates.size() + " direct expansion candidates");
        for (OWLAxiom ax : new TreeSet(directExpansionCandidates)) {
            System.out.println("\t" + ax);
        }
        System.out.println("There are " + expansionCandidates.size() + " expansion candidates");
        for (OWLAxiom ax : new TreeSet(expansionCandidates)) {
            System.out.println("\t" + ax);
        }
        return Collections.emptySet();
    }
}

