/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.setree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.semanticweb.owl.explanation.impl.setree.SETreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SETreeBuilder<O> {
    private List<O> elements = new ArrayList<O>();
    private Map<O, Integer> indexMap = new HashMap<O, Integer>();

    public SETreeBuilder(List<O> axioms) {
        this.elements = axioms;
        int index = 1;
        for (O ax : axioms) {
            this.indexMap.put(ax, index);
            ++index;
        }
    }

    public SETreeNode buildTree() {
        SETreeNode root = new SETreeNode(Collections.emptyList());
        this.extendNode(root);
        return root;
    }

    private void extendNode(SETreeNode<O> node) {
        int maxIndex;
        for (int i = maxIndex = this.getMaxIndex(node); i < this.elements.size(); ++i) {
            ArrayList<O> nodeElements = new ArrayList<O>(node.getElements());
            nodeElements.add(this.elements.get(i));
            SETreeNode<O> child = new SETreeNode<O>(nodeElements);
            node.addChild(child);
            this.extendNode(child);
        }
    }

    private int getMaxIndex(SETreeNode<O> node) {
        int maxIndex = 0;
        for (O element : node.getElements()) {
            int index = this.getIndexOf(element);
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        return maxIndex;
    }

    public int getIndexOf(O element) {
        return this.indexMap.get(element);
    }

    private void dump(SETreeNode<O> tree) {
        int depth = tree.getDepth();
        for (int i = 0; i < depth; ++i) {
            System.out.print("    ");
        }
        System.out.println(tree);
        for (SETreeNode child : tree.getChildren()) {
            this.dump(child);
        }
    }

    public static void main(String[] args) {
        List<Integer> list = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21);
        SETreeBuilder<Integer> builder = new SETreeBuilder<Integer>(list);
        SETreeNode root = builder.buildTree();
    }
}

