/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.laconic.BaseDescriptionGenerator;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.util.CollectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TauGenerator
extends BaseDescriptionGenerator {
    public TauGenerator(OWLDataFactory factory) {
        super(factory);
    }

    public Set<OWLClassExpression> visit(OWLClass desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        descs.add((OWLClassExpression)desc);
        descs.add((OWLClassExpression)this.getDataFactory().getOWLThing());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectComplementOf desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLClassExpression d : this.computeBeta(desc.getOperand())) {
            descs.add((OWLClassExpression)this.getDataFactory().getOWLObjectComplementOf(d));
        }
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectMaxCardinality desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLClassExpression filler : this.computeBeta((OWLClassExpression)desc.getFiller())) {
            descs.add((OWLClassExpression)this.getDataFactory().getOWLObjectMaxCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), filler));
        }
        descs.add((OWLClassExpression)this.getLimit());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectMinCardinality desc) {
        Set<OWLClassExpression> weakenedFillers = this.computeTau((OWLClassExpression)desc.getFiller());
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (int n = desc.getCardinality(); n > 0; --n) {
            for (OWLClassExpression filler : weakenedFillers) {
                result.add((OWLClassExpression)this.getDataFactory().getOWLObjectMinCardinality(n, (OWLObjectPropertyExpression)desc.getProperty(), filler));
            }
        }
        result.add((OWLClassExpression)this.getLimit());
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectUnionOf desc) {
        boolean anon = false;
        for (OWLClassExpression ce : desc.asDisjunctSet()) {
            if (!ce.isAnonymous()) continue;
            anon = true;
            break;
        }
        if (anon) {
            return super.visit(desc);
        }
        return CollectionFactory.createSet((Object[])new OWLClassExpression[]{desc, this.getLimit()});
    }

    @Override
    protected OWLClass getLimit() {
        return this.getDataFactory().getOWLThing();
    }

    @Override
    protected OWLDataRange getDataLimit() {
        return this.getDataFactory().getTopDatatype();
    }
}

