/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.laconic.IsLaconicChecker;
import org.semanticweb.owl.explanation.impl.laconic.LaconicCheckerMode;
import org.semanticweb.owl.explanation.impl.laconic.LaconicExplanationGeneratorBasedOnDeltaPlus;
import org.semanticweb.owl.explanation.impl.laconic.ModularityTreatment;
import org.semanticweb.owl.explanation.impl.laconic.OPlusGenerator;
import org.semanticweb.owl.explanation.impl.laconic.OPlusSplitting;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaconicExplanationGeneratorBasedOnOPlusWithDeltaPlusFiltering
implements ExplanationGenerator<OWLAxiom> {
    private Set<OWLAxiom> inputAxioms;
    private EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory;
    private ExplanationGeneratorFactory<OWLAxiom> delegateFactory;
    private ExplanationProgressMonitor<OWLAxiom> progressMonitor;
    private OPlusSplitting oplusSplitting = OPlusSplitting.TOP_LEVEL;
    private ModularityTreatment modularityTreatment = ModularityTreatment.MODULE;
    private int numberOfOPlusJustificationsFound = 0;

    public LaconicExplanationGeneratorBasedOnOPlusWithDeltaPlusFiltering(Set<? extends OWLAxiom> inputAxioms, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory, ExplanationGeneratorFactory<OWLAxiom> delegateFactory, ExplanationProgressMonitor<OWLAxiom> progressMonitor, OPlusSplitting spiltting, ModularityTreatment inputType) {
        this.inputAxioms = new HashSet<OWLAxiom>(inputAxioms);
        this.entailmentCheckerFactory = entailmentCheckerFactory;
        this.delegateFactory = delegateFactory;
        this.progressMonitor = progressMonitor;
        this.oplusSplitting = spiltting;
        this.modularityTreatment = inputType;
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment) throws ExplanationException {
        return this.getExplanations(entailment, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment, int limit) throws ExplanationException {
        HashSet<Explanation<OWLAxiom>> preferredLaconicExplanations;
        this.numberOfOPlusJustificationsFound = 0;
        TelemetryTimer computeOplusTimer = new TelemetryTimer();
        TelemetryTimer computeOplusJustificationsTimer = new TelemetryTimer();
        TelemetryTimer islaconicTimer = new TelemetryTimer();
        TelemetryTimer reconstituteTimer = new TelemetryTimer();
        TelemetryTimer ispreferredCheckTimer = new TelemetryTimer();
        DefaultTelemetryInfo info = new DefaultTelemetryInfo(this.getClass().getSimpleName(), computeOplusTimer, computeOplusJustificationsTimer, islaconicTimer, reconstituteTimer, ispreferredCheckTimer);
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        transmitter.beginTransmission(info);
        transmitter.recordMeasurement((TelemetryInfo)info, "oplus splitting", this.oplusSplitting.toString());
        transmitter.recordMeasurement((TelemetryInfo)info, "input type", this.modularityTreatment.toString());
        try {
            Set<Object> oplusInput;
            OWLDataFactory dataFactory = OWLDataFactoryImpl.getInstance();
            OPlusGenerator transformation = new OPlusGenerator(dataFactory, this.oplusSplitting);
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            transmitter.recordMeasurement((TelemetryInfo)info, "input axioms size", this.inputAxioms.size());
            if (this.modularityTreatment.equals((Object)ModularityTreatment.MODULE)) {
                SyntacticLocalityModuleExtractor extractor = new SyntacticLocalityModuleExtractor(man, null, this.inputAxioms, ModuleType.STAR);
                oplusInput = extractor.extract(entailment.getSignature());
            } else {
                oplusInput = new HashSet<OWLAxiom>(this.inputAxioms);
            }
            transmitter.recordMeasurement((TelemetryInfo)info, "module size", oplusInput.size());
            computeOplusTimer.start();
            Set<OWLAxiom> oplusAxiomsRaw = transformation.transform(oplusInput);
            computeOplusTimer.stop();
            transmitter.recordTiming(info, "time to compute oplus", computeOplusTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "oplus axioms size", oplusAxiomsRaw.size());
            HashSet<OWLAxiom> oplusAxioms = new HashSet<OWLAxiom>(oplusAxiomsRaw);
            ExplanationGenerator<OWLAxiom> gen = this.delegateFactory.createExplanationGenerator(oplusAxioms, (ExplanationProgressMonitor<OWLAxiom>)new MediatingProgresssMonitor());
            computeOplusJustificationsTimer.start();
            Set<Explanation<OWLAxiom>> oplusExpls = gen.getExplanations(entailment);
            computeOplusJustificationsTimer.stop();
            transmitter.recordTiming(info, "time to compute oplus justifications", computeOplusJustificationsTimer);
            IsLaconicChecker checker = new IsLaconicChecker(dataFactory, this.entailmentCheckerFactory, LaconicCheckerMode.EARLY_TERMINATING);
            HashSet<Explanation<OWLAxiom>> laconicExplanations = new HashSet<Explanation<OWLAxiom>>();
            islaconicTimer.start();
            for (Explanation<OWLAxiom> expl : oplusExpls) {
                if (this.progressMonitor.isCancelled()) {
                    throw new ExplanationGeneratorInterruptedException();
                }
                if (!checker.isLaconic(expl)) continue;
                laconicExplanations.add(expl);
            }
            islaconicTimer.stop();
            transmitter.recordTiming(info, "time to check laconic oplus justifications", islaconicTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of laconic oplus justifications", laconicExplanations.size());
            reconstituteTimer.start();
            Set<Explanation<OWLAxiom>> reconstitutedLaconicExpls = this.getReconstitutedExplanations(dataFactory, transformation, laconicExplanations);
            reconstituteTimer.stop();
            transmitter.recordTiming(info, "time to reconstitute justifications", reconstituteTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of reconstituted justifications", reconstitutedLaconicExpls.size());
            preferredLaconicExplanations = new HashSet<Explanation<OWLAxiom>>();
            HashMap<Explanation, Set<OWLAxiom>> oplusCache = new HashMap<Explanation, Set<OWLAxiom>>();
            ispreferredCheckTimer.start();
            HashSet<Explanation> toFilter = new HashSet<Explanation>();
            ArrayList<Explanation<OWLAxiom>> explsList = new ArrayList<Explanation<OWLAxiom>>(reconstitutedLaconicExpls);
            for (int i = 0; i < explsList.size(); ++i) {
                for (int j = i + 1; j < explsList.size(); ++j) {
                    Set<OWLAxiom> oplusJ;
                    Explanation explanation = (Explanation)explsList.get(i);
                    Explanation explJ = (Explanation)explsList.get(j);
                    Set<OWLAxiom> oplusI = (Set<OWLAxiom>)oplusCache.get(explanation);
                    if (oplusI == null) {
                        OPlusGenerator generator = new OPlusGenerator(dataFactory, OPlusSplitting.NONE);
                        oplusI = generator.transform(explanation.getAxioms());
                        oplusCache.put(explanation, oplusI);
                    }
                    if ((oplusJ = (Set<OWLAxiom>)oplusCache.get(explJ)) == null) {
                        OPlusGenerator generator = new OPlusGenerator(dataFactory, OPlusSplitting.NONE);
                        oplusJ = generator.transform(explJ.getAxioms());
                        oplusCache.put(explJ, oplusJ);
                    }
                    if (!oplusI.containsAll(oplusJ) && !oplusJ.containsAll(oplusI)) continue;
                    toFilter.add(explanation);
                    toFilter.add(explJ);
                }
            }
            preferredLaconicExplanations.addAll(reconstitutedLaconicExpls);
            preferredLaconicExplanations.removeAll(toFilter);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of non-check preferred laconic justifications", preferredLaconicExplanations.size());
            transmitter.recordMeasurement((TelemetryInfo)info, "number of check laconic justifications", toFilter.size());
            for (final Explanation laconicExpl : toFilter) {
                Set<OWLAxiom> set = this.getSourceAxioms(laconicExpl, transformation);
                ExplanationGenerator<OWLAxiom> explanationGenerator = this.delegateFactory.createExplanationGenerator(set);
                Set<Explanation<OWLAxiom>> regularExpls = explanationGenerator.getExplanations((OWLAxiom)laconicExpl.getEntailment());
                try {
                    for (Explanation<OWLAxiom> regularExpl : regularExpls) {
                        int size = preferredLaconicExplanations.size();
                        LaconicExplanationGeneratorBasedOnDeltaPlus lacGen = new LaconicExplanationGeneratorBasedOnDeltaPlus(regularExpl.getAxioms(), this.entailmentCheckerFactory, this.delegateFactory, new ExplanationProgressMonitor<OWLAxiom>(){
                            private boolean cancelled = false;

                            @Override
                            public void foundExplanation(ExplanationGenerator<OWLAxiom> owlAxiomExplanationGenerator, Explanation<OWLAxiom> owlAxiomExplanation, Set<Explanation<OWLAxiom>> allFoundExplanations) {
                                if (owlAxiomExplanation.equals(laconicExpl)) {
                                    preferredLaconicExplanations.add(laconicExpl);
                                    this.cancelled = true;
                                }
                            }

                            @Override
                            public boolean isCancelled() {
                                return this.cancelled;
                            }
                        });
                        Set<Explanation<OWLAxiom>> deltaPlusGeneratedExpls = lacGen.getExplanations((OWLAxiom)laconicExpl.getEntailment());
                        if (preferredLaconicExplanations.size() == size) continue;
                    }
                }
                catch (ExplanationGeneratorInterruptedException e) {
                    System.out.println("Early termination");
                }
            }
            ispreferredCheckTimer.stop();
            HashSet<Explanation<Explanation>> progressFound = new HashSet<Explanation<Explanation>>();
            for (Explanation explanation : preferredLaconicExplanations) {
                progressFound.add(explanation);
                this.progressMonitor.foundExplanation(this, explanation, progressFound);
            }
            transmitter.recordTiming(info, "time to check preferred laconic justifications", ispreferredCheckTimer);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of preferred laconic justifications", preferredLaconicExplanations.size());
            Object var36_44 = null;
            transmitter.recordMeasurement((TelemetryInfo)info, "number of oplus justifications", this.numberOfOPlusJustificationsFound);
            transmitter.endTransmission(info);
        }
        catch (Throwable throwable) {
            Object var36_45 = null;
            transmitter.recordMeasurement((TelemetryInfo)info, "number of oplus justifications", this.numberOfOPlusJustificationsFound);
            transmitter.endTransmission(info);
            throw throwable;
        }
        return preferredLaconicExplanations;
    }

    private Set<Explanation<OWLAxiom>> getReconstitutedExplanations(OWLDataFactory dataFactory, OPlusGenerator transformation, Set<Explanation<OWLAxiom>> laconicExplanations) {
        HashSet<Explanation<OWLAxiom>> reconstitutedLaconicExpls = new HashSet<Explanation<OWLAxiom>>();
        for (Explanation<OWLAxiom> expl : laconicExplanations) {
            reconstitutedLaconicExpls.addAll(this.getReconstitutedExplanations(expl, transformation, dataFactory));
        }
        return reconstitutedLaconicExpls;
    }

    private Set<OWLAxiom> getSourceAxioms(Explanation<OWLAxiom> expl, OPlusGenerator oPlusGenerator) {
        HashSet<OWLAxiom> result = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : expl.getAxioms()) {
            Set<OWLAxiom> sourceAxioms = oPlusGenerator.getAxiom2SourceMap().get(ax);
            if (sourceAxioms == null) continue;
            result.addAll(sourceAxioms);
        }
        return result;
    }

    private Set<Explanation<OWLAxiom>> getReconstitutedExplanations(Explanation<OWLAxiom> expl, OPlusGenerator oPlusGenerator, OWLDataFactory dataFactory) {
        HashSet<OWLAxiom> nonSubClassOfAxioms = new HashSet<OWLAxiom>();
        HashSet<OWLSubClassOfAxiom> uniqueSourceSubClassAxioms = new HashSet<OWLSubClassOfAxiom>();
        HashSet<OWLSubClassOfAxiom> reconstitutedAxioms = new HashSet<OWLSubClassOfAxiom>();
        HashSet<OWLAxiom> reconstitutedAxiomSourcesWithMultipleSources = new HashSet<OWLAxiom>();
        HashSet sameSourceAxiomSources = new HashSet();
        OPlusGenerator strictOPlusGenerator = new OPlusGenerator(dataFactory, OPlusSplitting.NONE);
        Set<OWLAxiom> strictOPlus = strictOPlusGenerator.transform(this.getSourceAxioms(expl, oPlusGenerator));
        for (OWLAxiom explAx : expl.getAxioms()) {
            if (explAx instanceof OWLSubClassOfAxiom) {
                OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)explAx;
                Set<OWLAxiom> sameSourceAxioms = oPlusGenerator.getSameSourceAxioms((OWLAxiom)sca, expl.getAxioms());
                if (!sameSourceAxioms.isEmpty()) {
                    HashSet<OWLClassExpression> superClassConjuncts = new HashSet<OWLClassExpression>();
                    HashSet<OWLClassExpression> subClassDisjuncts = new HashSet<OWLClassExpression>();
                    for (OWLAxiom ax : sameSourceAxioms) {
                        if (!(ax instanceof OWLSubClassOfAxiom)) continue;
                        OWLSubClassOfAxiom sameSourceSCA = (OWLSubClassOfAxiom)ax;
                        superClassConjuncts.addAll(sameSourceSCA.getSuperClass().asConjunctSet());
                        subClassDisjuncts.addAll(sameSourceSCA.getSubClass().asDisjunctSet());
                        if (!oPlusGenerator.hasMultipleSources(ax)) continue;
                        reconstitutedAxiomSourcesWithMultipleSources.add(ax);
                    }
                    subClassDisjuncts.addAll(sca.getSubClass().asDisjunctSet());
                    superClassConjuncts.addAll(sca.getSuperClass().asConjunctSet());
                    OWLSubClassOfAxiom mergedAxiom = this.createSubClassAxiom(dataFactory, subClassDisjuncts, superClassConjuncts);
                    if (!strictOPlus.contains(mergedAxiom)) continue;
                    reconstitutedAxioms.add(mergedAxiom);
                    oPlusGenerator.addSources((OWLAxiom)mergedAxiom, oPlusGenerator.getSources(explAx));
                    continue;
                }
                uniqueSourceSubClassAxioms.add(sca);
                continue;
            }
            nonSubClassOfAxioms.add(explAx);
        }
        if (reconstitutedAxioms.isEmpty()) {
            return Collections.singleton(expl);
        }
        HashSet<OWLAxiom> pool = new HashSet<OWLAxiom>();
        pool.addAll(nonSubClassOfAxioms);
        pool.addAll(uniqueSourceSubClassAxioms);
        pool.addAll(reconstitutedAxioms);
        pool.addAll(reconstitutedAxiomSourcesWithMultipleSources);
        if (reconstitutedAxiomSourcesWithMultipleSources.isEmpty()) {
            return Collections.singleton(new Explanation<OWLAxiom>(expl.getEntailment(), pool));
        }
        ExplanationGenerator<OWLAxiom> expGen = this.delegateFactory.createExplanationGenerator(pool);
        return expGen.getExplanations(expl.getEntailment());
    }

    private OWLSubClassOfAxiom createSubClassAxiom(OWLDataFactory dataFactory, Set<OWLClassExpression> subClassDisjuncts, Set<OWLClassExpression> superClassConjuncts) {
        Object mergedSubClass = subClassDisjuncts.size() == 1 ? subClassDisjuncts.iterator().next() : dataFactory.getOWLObjectUnionOf(subClassDisjuncts);
        Object mergedSuperClass = superClassConjuncts.size() == 1 ? superClassConjuncts.iterator().next() : dataFactory.getOWLObjectIntersectionOf(superClassConjuncts);
        return dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)mergedSubClass, (OWLClassExpression)mergedSuperClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MediatingProgresssMonitor
    implements ExplanationProgressMonitor<OWLAxiom> {
        private MediatingProgresssMonitor() {
        }

        @Override
        public void foundExplanation(ExplanationGenerator<OWLAxiom> owlAxiomExplanationGenerator, Explanation<OWLAxiom> owlAxiomExplanation, Set<Explanation<OWLAxiom>> allFoundExplanations) {
            System.out.println("\tFound " + allFoundExplanations.size() + " OPlus Justifications");
            LaconicExplanationGeneratorBasedOnOPlusWithDeltaPlusFiltering.this.numberOfOPlusJustificationsFound = allFoundExplanations.size();
            if (this.isCancelled()) {
                throw new ExplanationGeneratorInterruptedException();
            }
        }

        @Override
        public boolean isCancelled() {
            return LaconicExplanationGeneratorBasedOnOPlusWithDeltaPlusFiltering.this.progressMonitor.isCancelled();
        }
    }
}

