/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.laconic.IsLaconicChecker;
import org.semanticweb.owl.explanation.impl.laconic.LaconicCheckerMode;
import org.semanticweb.owl.explanation.impl.util.DeltaPlusTransformation;
import org.semanticweb.owl.explanation.impl.util.DeltaTransformationUnfolder;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;
import uk.ac.manchester.cs.owlapi.modularity.SyntacticLocalityModuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaconicExplanationGeneratorBasedOnDeltaPlus
implements ExplanationGenerator<OWLAxiom> {
    private Set<OWLAxiom> inputAxioms;
    private EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory;
    private ExplanationGeneratorFactory<OWLAxiom> delegateFactory;
    private ExplanationProgressMonitor<OWLAxiom> progressMonitor;

    public LaconicExplanationGeneratorBasedOnDeltaPlus(Set<? extends OWLAxiom> inputAxioms, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory, ExplanationGeneratorFactory<OWLAxiom> delegateFactory, ExplanationProgressMonitor<OWLAxiom> progressMonitor) {
        this.inputAxioms = new HashSet<OWLAxiom>(inputAxioms);
        this.entailmentCheckerFactory = entailmentCheckerFactory;
        this.delegateFactory = delegateFactory;
        this.progressMonitor = progressMonitor;
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment) throws ExplanationException {
        return this.getExplanations(entailment, Integer.MAX_VALUE);
    }

    @Override
    public Set<Explanation<OWLAxiom>> getExplanations(OWLAxiom entailment, int limit) throws ExplanationException {
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>();
        for (OWLAxiom ax : this.inputAxioms) {
            signature.addAll(ax.getSignature());
        }
        OWLDataFactory dataFactory = OWLDataFactoryImpl.getInstance();
        DeltaPlusTransformation transformation = new DeltaPlusTransformation(dataFactory);
        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
        SyntacticLocalityModuleExtractor extractor = new SyntacticLocalityModuleExtractor(man, null, this.inputAxioms, ModuleType.STAR);
        Set moduleAxioms = extractor.extract(entailment.getSignature());
        Set<OWLAxiom> flattenedAxioms = transformation.transform(moduleAxioms);
        ExplanationGenerator<OWLAxiom> gen = this.delegateFactory.createExplanationGenerator(flattenedAxioms);
        Set<Explanation<OWLAxiom>> expls = gen.getExplanations(entailment);
        IsLaconicChecker checker = new IsLaconicChecker(dataFactory, this.entailmentCheckerFactory, LaconicCheckerMode.EARLY_TERMINATING);
        HashSet<Explanation<OWLAxiom>> laconicExplanations = new HashSet<Explanation<OWLAxiom>>();
        HashSet<Explanation<OWLAxiom>> nonLaconicExplanations = new HashSet<Explanation<OWLAxiom>>();
        Iterator<Explanation<Object>> i$ = expls.iterator();
        while (i$.hasNext()) {
            DeltaTransformationUnfolder unfolder = new DeltaTransformationUnfolder(dataFactory);
            Explanation<OWLAxiom> explanation = i$.next();
            Set<OWLAxiom> unfoldedAxioms = unfolder.getUnfolded(explanation.getAxioms(), signature);
            Explanation<OWLAxiom> unfoldedExpl = new Explanation<OWLAxiom>(entailment, unfoldedAxioms);
            if (checker.isLaconic(unfoldedExpl)) {
                boolean added = laconicExplanations.add(unfoldedExpl);
                if (!added) continue;
                this.progressMonitor.foundExplanation(this, unfoldedExpl, new HashSet(laconicExplanations));
                continue;
            }
            nonLaconicExplanations.add(unfoldedExpl);
        }
        if (laconicExplanations.isEmpty()) {
            System.out.println("NOT-FOUND-ANY!");
            for (Explanation<Object> explanation : nonLaconicExplanations) {
                System.out.println("NON-LACONIC:");
                System.out.println(explanation);
            }
        }
        return laconicExplanations;
    }
}

