/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.api.NullExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.laconic.OPlusGenerator;
import org.semanticweb.owl.explanation.impl.laconic.OPlusSplitting;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import uk.ac.manchester.cs.bhig.util.MutableTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaconicExplanationGenerator<E>
implements ExplanationGenerator<E>,
ExplanationProgressMonitor<E> {
    private ExplanationGeneratorFactory<E> explanationGeneratorFactory;
    private OWLOntologyManager man = OWLManager.createOWLOntologyManager();
    private OWLOntology ont;
    private Set<Explanation<E>> lastRegularJusts;
    private Set<Explanation<E>> allPreviouslyFoundJustifications;
    private Set<Explanation<E>> foundLaconicJustifications;
    private ExplanationProgressMonitor<E> progressMonitor;
    private int limit;
    private Set<? extends OWLAxiom> axioms;

    public LaconicExplanationGenerator(Set<? extends OWLAxiom> axioms, ExplanationGeneratorFactory<E> explanationGeneratorFactory, ExplanationProgressMonitor<E> progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.explanationGeneratorFactory = explanationGeneratorFactory;
        this.limit = Integer.MAX_VALUE;
        this.axioms = axioms;
        this.progressMonitor = progressMonitor != null ? progressMonitor : new NullExplanationProgressMonitor();
        this.foundLaconicJustifications = new HashSet<Explanation<E>>();
        try {
            this.ont = this.man.createOntology(Collections.unmodifiableSet(axioms));
        }
        catch (OWLOntologyCreationException e) {
            e.printStackTrace();
        }
        catch (OWLOntologyChangeException e) {
            e.printStackTrace();
        }
        this.lastRegularJusts = new HashSet<Explanation<E>>();
    }

    public Set<OWLAxiom> computeOPlus(Set<OWLAxiom> axioms) {
        OPlusGenerator oPlusGenerator = new OPlusGenerator(this.man.getOWLDataFactory(), OPlusSplitting.TOP_LEVEL);
        HashSet<OWLAxiom> oPlus = new HashSet<OWLAxiom>();
        for (OWLAxiom ax : axioms) {
            Set weakenedAxioms = (Set)ax.accept((OWLAxiomVisitorEx)oPlusGenerator);
            oPlus.addAll(weakenedAxioms);
        }
        for (OWLAxiom ax : oPlus) {
            OWLEquivalentClassesAxiom eca;
            if (!(ax instanceof OWLEquivalentClassesAxiom) || !oPlus.containsAll((eca = (OWLEquivalentClassesAxiom)ax).asOWLSubClassOfAxioms())) continue;
            System.out.println("POTENTIAL OPT!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!****************");
        }
        return oPlus;
    }

    public List<Integer> getPruningDifferences() {
        return null;
    }

    public MutableTree<Explanation> getHst() {
        return null;
    }

    public Set<Explanation<E>> computePreciseJusts(E entailment, int limit) throws OWLException {
        return this.computePreciseJustsOptimised(entailment, limit);
    }

    public Set<Explanation<E>> getLastRegularJustifications() {
        return this.lastRegularJusts;
    }

    @Override
    public void foundExplanation(ExplanationGenerator<E> explanationGenerator, Explanation<E> explanation, Set<Explanation<E>> allFoundExplanations) {
        this.notifyLaconicExplanationGeneratorProgressMonitor(explanation);
    }

    @Override
    public boolean isCancelled() {
        return this.isAtFoundLaconicJustificationsLimit() || this.progressMonitor.isCancelled();
    }

    private boolean isAtFoundLaconicJustificationsLimit() {
        return this.limit == this.foundLaconicJustifications.size();
    }

    private void notifyLaconicExplanationGeneratorProgressMonitor(Explanation<E> explanation) {
        try {
            if (this.isLaconic(explanation) && !this.foundLaconicJustifications.contains(explanation)) {
                this.foundLaconicJustifications.add(explanation);
                this.progressMonitor.foundExplanation(this, explanation, this.foundLaconicJustifications);
            }
        }
        catch (ExplanationException e) {
            throw new OWLRuntimeException((Throwable)((Object)e));
        }
    }

    public Set<Explanation<E>> computePreciseJustsOptimised(E entailment, int limit) throws OWLException {
        HashSet<Explanation<E>> allPrevJustsCopy;
        this.limit = limit;
        this.foundLaconicJustifications.clear();
        ExplanationGenerator<E> gen = this.explanationGeneratorFactory.createExplanationGenerator(this.axioms, this);
        Set<Explanation<E>> regularJusts = null;
        try {
            regularJusts = gen.getExplanations(entailment);
        }
        catch (ExplanationGeneratorInterruptedException e) {
            return this.foundLaconicJustifications;
        }
        if (this.isCancelled()) {
            return this.foundLaconicJustifications;
        }
        this.lastRegularJusts.clear();
        this.allPreviouslyFoundJustifications = new HashSet<Explanation<E>>();
        this.allPreviouslyFoundJustifications.addAll(regularJusts);
        HashSet<OWLAxiom> axiomsInPreviousOntology = new HashSet<OWLAxiom>();
        do {
            if (this.isCancelled()) {
                return this.getReconstitutedLaconicJustifications();
            }
            HashSet<OWLAxiom> unionOfAllJustifications = new HashSet<OWLAxiom>();
            for (Explanation<E> exp : this.allPreviouslyFoundJustifications) {
                unionOfAllJustifications.addAll(exp.getAxioms());
            }
            Set<OWLAxiom> oPlus = this.computeOPlus(unionOfAllJustifications);
            HashSet<OWLAxiom> augmentedAxioms = new HashSet<OWLAxiom>(oPlus);
            for (OWLLogicalAxiom ax : this.ont.getLogicalAxioms()) {
                if (unionOfAllJustifications.contains(ax) && !oPlus.contains(ax)) continue;
                augmentedAxioms.add((OWLAxiom)ax);
            }
            if (((Object)augmentedAxioms).equals(axiomsInPreviousOntology)) break;
            ExplanationGenerator<E> gen2 = this.explanationGeneratorFactory.createExplanationGenerator(augmentedAxioms, this);
            axiomsInPreviousOntology.clear();
            axiomsInPreviousOntology.addAll(augmentedAxioms);
            allPrevJustsCopy = new HashSet<Explanation<E>>(this.allPreviouslyFoundJustifications);
            Set<Explanation<E>> currentJustifications = null;
            try {
                currentJustifications = gen2.getExplanations(entailment);
            }
            catch (ExplanationGeneratorInterruptedException e) {
                return this.getReconstitutedLaconicJustifications();
            }
            if (this.isCancelled()) {
                return this.getReconstitutedLaconicJustifications();
            }
            this.allPreviouslyFoundJustifications.addAll(currentJustifications);
        } while (!((Object)this.allPreviouslyFoundJustifications).equals(allPrevJustsCopy));
        return this.getReconstitutedLaconicJustifications();
    }

    public boolean isLaconic(Explanation<E> justification) throws ExplanationException {
        Set<OWLAxiom> justificationSigmaClosure = this.computeOPlus(justification.getAxioms());
        ExplanationGenerator<E> gen2 = this.explanationGeneratorFactory.createExplanationGenerator(justificationSigmaClosure);
        Set<Explanation<E>> exps = gen2.getExplanations(justification.getEntailment(), 2);
        return ((Object)Collections.singleton(justification)).equals(exps);
    }

    private Set<Explanation<E>> getReconstitutedLaconicJustifications() {
        HashMap<OWLAxiom, Set<OWLAxiom>> sourceAxioms2OPlus = new HashMap<OWLAxiom, Set<OWLAxiom>>();
        for (Explanation<E> exp : this.allPreviouslyFoundJustifications) {
            for (OWLAxiom ax : exp.getAxioms()) {
                if (!this.ont.containsAxiom(ax)) continue;
                sourceAxioms2OPlus.put(ax, this.computeOPlus(Collections.singleton(ax)));
            }
        }
        HashSet<Explanation<Explanation<E>>> reconstituedExplanations = new HashSet<Explanation<Explanation<E>>>();
        for (Explanation<E> laconicExp : this.foundLaconicJustifications) {
            HashMap lhs2SubClassAxiom = new HashMap();
            HashSet<OWLAxiom> reconstituedAxioms = new HashSet<OWLAxiom>();
            for (OWLAxiom laconicAx : laconicExp.getAxioms()) {
                if (laconicAx instanceof OWLSubClassOfAxiom) {
                    OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)laconicAx;
                    if (sca.getSubClass().isAnonymous()) {
                        reconstituedAxioms.add((OWLAxiom)sca);
                        continue;
                    }
                    HashMap<OWLAxiom, HashSet<OWLSubClassOfAxiom>> source2AxiomMap = (HashMap<OWLAxiom, HashSet<OWLSubClassOfAxiom>>)lhs2SubClassAxiom.get(sca.getSubClass().asOWLClass());
                    if (source2AxiomMap == null) {
                        source2AxiomMap = new HashMap<OWLAxiom, HashSet<OWLSubClassOfAxiom>>();
                        lhs2SubClassAxiom.put(sca.getSubClass().asOWLClass(), source2AxiomMap);
                    }
                    for (OWLAxiom sourceAx : sourceAxioms2OPlus.keySet()) {
                        if (!((Set)sourceAxioms2OPlus.get(sourceAx)).contains(sca)) continue;
                        HashSet<OWLSubClassOfAxiom> subClassAxioms = (HashSet<OWLSubClassOfAxiom>)source2AxiomMap.get(sourceAx);
                        if (subClassAxioms == null) {
                            subClassAxioms = new HashSet<OWLSubClassOfAxiom>();
                            source2AxiomMap.put(sourceAx, subClassAxioms);
                        }
                        subClassAxioms.add(sca);
                    }
                    continue;
                }
                reconstituedAxioms.add(laconicAx);
            }
            HashSet<OWLSubClassOfAxiom> consumedAxioms = new HashSet<OWLSubClassOfAxiom>();
            for (OWLClass lhs : lhs2SubClassAxiom.keySet()) {
                Map source2SubClassAxiom = (Map)lhs2SubClassAxiom.get(lhs);
                for (OWLAxiom source : source2SubClassAxiom.keySet()) {
                    HashSet<OWLClassExpression> rightHandSides = new HashSet<OWLClassExpression>();
                    for (OWLSubClassOfAxiom subClassAx : (Set)source2SubClassAxiom.get(source)) {
                        if (consumedAxioms.contains(subClassAx)) continue;
                        rightHandSides.add(subClassAx.getSuperClass());
                        consumedAxioms.add(subClassAx);
                    }
                    if (rightHandSides.size() == 1) {
                        reconstituedAxioms.add((OWLAxiom)this.man.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)lhs, (OWLClassExpression)rightHandSides.iterator().next()));
                        continue;
                    }
                    if (rightHandSides.size() <= 1) continue;
                    OWLObjectIntersectionOf conjunction = this.man.getOWLDataFactory().getOWLObjectIntersectionOf(rightHandSides);
                    reconstituedAxioms.add((OWLAxiom)this.man.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)lhs, (OWLClassExpression)conjunction));
                }
            }
            Explanation<E> explanation = new Explanation<E>(laconicExp.getEntailment(), reconstituedAxioms);
            reconstituedExplanations.add(explanation);
        }
        return reconstituedExplanations;
    }

    @Override
    public Set<Explanation<E>> getExplanations(E entailment) throws ExplanationException {
        try {
            return this.computePreciseJustsOptimised(entailment, Integer.MAX_VALUE);
        }
        catch (OWLException e) {
            throw new ExplanationException(e);
        }
    }

    @Override
    public Set<Explanation<E>> getExplanations(E entailment, int limit) throws ExplanationException {
        try {
            return this.computePreciseJustsOptimised(entailment, limit);
        }
        catch (OWLException e) {
            throw new ExplanationException(e);
        }
    }
}

