/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.laconic.LaconicCheckerMode;
import org.semanticweb.owl.explanation.impl.util.DeltaTransformation;
import org.semanticweb.owl.explanation.telemetry.DefaultTelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryInfo;
import org.semanticweb.owl.explanation.telemetry.TelemetryTimer;
import org.semanticweb.owl.explanation.telemetry.TelemetryTransmitter;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsLaconicChecker {
    private OWLDataFactory dataFactory;
    private EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory;
    private LaconicCheckerMode checkerMode;
    private DeltaTransformation deltaTransformation;
    private Set<OWLAnnotation> nonLaconicSourceAxioms = new HashSet<OWLAnnotation>();

    public IsLaconicChecker(OWLDataFactory dataFactory, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory) {
        this(dataFactory, entailmentCheckerFactory, LaconicCheckerMode.EARLY_TERMINATING);
    }

    public IsLaconicChecker(OWLDataFactory dataFactory, EntailmentCheckerFactory<OWLAxiom> entailmentCheckerFactory, LaconicCheckerMode checkerMode) {
        this.dataFactory = dataFactory;
        this.entailmentCheckerFactory = entailmentCheckerFactory;
        this.checkerMode = checkerMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLaconic(Explanation<OWLAxiom> expl) {
        int entailmentCheckCount;
        boolean laconic;
        DefaultTelemetryInfo info;
        TelemetryTransmitter transmitter;
        block13: {
            boolean bl;
            block12: {
                boolean bl2;
                block11: {
                    boolean bl3;
                    block10: {
                        boolean bl4;
                        block9: {
                            if (expl.isJustificationEntailment()) {
                                return true;
                            }
                            transmitter = TelemetryTransmitter.getTransmitter();
                            info = new DefaultTelemetryInfo("laconiccheck", new TelemetryTimer[0]);
                            transmitter.beginTransmission(info);
                            laconic = true;
                            entailmentCheckCount = 0;
                            this.nonLaconicSourceAxioms.clear();
                            try {
                                Set<OWLAxiom> flattened = this.getFlattenedAxioms(expl.getAxioms());
                                transmitter.recordMeasurement((TelemetryInfo)info, "justification size", expl.getSize());
                                transmitter.recordMeasurement((TelemetryInfo)info, "delta axioms size", flattened.size());
                                EntailmentChecker<OWLAxiom> checker = this.entailmentCheckerFactory.createEntailementChecker(expl.getEntailment());
                                for (OWLAxiom curAxiom : new ArrayList<OWLAxiom>(flattened)) {
                                    flattened.remove(curAxiom);
                                    ++entailmentCheckCount;
                                    if (checker.isEntailed(flattened)) {
                                        laconic = false;
                                        this.recordNonLaconicity(info, curAxiom);
                                        if (this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) {
                                            boolean bl5 = false;
                                            Object var13_12 = null;
                                            transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
                                            transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", entailmentCheckCount);
                                            transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", this.nonLaconicSourceAxioms.size());
                                            transmitter.endTransmission(info);
                                            return bl5;
                                        }
                                    }
                                    flattened.add(curAxiom);
                                    if (!(curAxiom instanceof OWLSubClassOfAxiom)) continue;
                                    OWLSubClassOfAxiom sca = (OWLSubClassOfAxiom)curAxiom;
                                    if (sca.getSubClass() instanceof OWLObjectMinCardinality) {
                                        ++entailmentCheckCount;
                                        if (!this.isEntailedByWeakerMinCardinalitySubClass(sca, flattened, checker)) continue;
                                        laconic = false;
                                        this.recordNonLaconicity(info, curAxiom);
                                        if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                                        bl4 = false;
                                        break block9;
                                    }
                                    if (sca.getSubClass() instanceof OWLObjectMaxCardinality) {
                                        ++entailmentCheckCount;
                                        if (!this.isEntailedByWeakerMaxCardinalitySubClass(sca, flattened, checker)) continue;
                                        laconic = false;
                                        this.recordNonLaconicity(info, curAxiom);
                                        if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                                        bl3 = false;
                                        break block10;
                                    }
                                    if (sca.getSuperClass() instanceof OWLObjectMinCardinality) {
                                        ++entailmentCheckCount;
                                        if (!this.isEntailedByWeakerMinCardinalitySuperClass(sca, flattened, checker)) continue;
                                        laconic = false;
                                        this.recordNonLaconicity(info, curAxiom);
                                        if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                                        bl2 = false;
                                        break block11;
                                    }
                                    if (!(sca.getSuperClass() instanceof OWLObjectMaxCardinality)) continue;
                                    ++entailmentCheckCount;
                                    if (!this.isEntailedByWeakerMaxCardinalitySuperClass(sca, flattened, checker)) continue;
                                    laconic = false;
                                    this.recordNonLaconicity(info, curAxiom);
                                    if (!this.checkerMode.equals((Object)LaconicCheckerMode.EARLY_TERMINATING)) continue;
                                    bl = false;
                                    break block12;
                                }
                                break block13;
                            }
                            catch (Throwable throwable) {
                                Object var13_18 = null;
                                transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
                                transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", entailmentCheckCount);
                                transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", this.nonLaconicSourceAxioms.size());
                                transmitter.endTransmission(info);
                                throw throwable;
                            }
                        }
                        Object var13_13 = null;
                        transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
                        transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", entailmentCheckCount);
                        transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", this.nonLaconicSourceAxioms.size());
                        transmitter.endTransmission(info);
                        return bl4;
                    }
                    Object var13_14 = null;
                    transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
                    transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", entailmentCheckCount);
                    transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", this.nonLaconicSourceAxioms.size());
                    transmitter.endTransmission(info);
                    return bl3;
                }
                Object var13_15 = null;
                transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
                transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", entailmentCheckCount);
                transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", this.nonLaconicSourceAxioms.size());
                transmitter.endTransmission(info);
                return bl2;
            }
            Object var13_16 = null;
            transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
            transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", entailmentCheckCount);
            transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", this.nonLaconicSourceAxioms.size());
            transmitter.endTransmission(info);
            return bl;
        }
        Object var13_17 = null;
        transmitter.recordMeasurement((TelemetryInfo)info, "laconic", laconic);
        transmitter.recordMeasurement((TelemetryInfo)info, "entailment check count", entailmentCheckCount);
        transmitter.recordMeasurement((TelemetryInfo)info, "number of non-laconic source axioms", this.nonLaconicSourceAxioms.size());
        transmitter.endTransmission(info);
        return laconic;
    }

    private void recordNonLaconicity(TelemetryInfo info, OWLAxiom curAxiom) {
        TelemetryTransmitter transmitter = TelemetryTransmitter.getTransmitter();
        this.nonLaconicSourceAxioms.addAll(curAxiom.getAnnotations());
        int modalDepth = this.deltaTransformation.getModalDepth(curAxiom);
        transmitter.recordMeasurement(info, "superfluity depth", modalDepth);
    }

    private boolean isEntailedByWeakerMinCardinalitySubClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMinCardinality cardinality = (OWLObjectMinCardinality)ax.getSubClass();
        int card = cardinality.getCardinality();
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMinCardinality weaker = this.dataFactory.getOWLObjectMinCardinality(card + 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)weaker, ax.getSuperClass());
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedByWeakerMaxCardinalitySubClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMaxCardinality cardinality = (OWLObjectMaxCardinality)ax.getSubClass();
        int card = cardinality.getCardinality();
        if (card == 0) {
            return false;
        }
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMaxCardinality weaker = this.dataFactory.getOWLObjectMaxCardinality(card - 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom((OWLClassExpression)weaker, ax.getSuperClass());
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedByWeakerMinCardinalitySuperClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMinCardinality cardinality = (OWLObjectMinCardinality)ax.getSuperClass();
        int card = cardinality.getCardinality();
        if (card == 1 || card == 0) {
            return false;
        }
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMinCardinality weaker = this.dataFactory.getOWLObjectMinCardinality(card - 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom(ax.getSubClass(), (OWLClassExpression)weaker);
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedByWeakerMaxCardinalitySuperClass(OWLSubClassOfAxiom ax, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        OWLObjectMaxCardinality cardinality = (OWLObjectMaxCardinality)ax.getSuperClass();
        int card = cardinality.getCardinality();
        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)cardinality.getProperty();
        OWLClassExpression ce = (OWLClassExpression)cardinality.getFiller();
        OWLObjectMaxCardinality weaker = this.dataFactory.getOWLObjectMaxCardinality(card + 1, prop, ce);
        OWLSubClassOfAxiom weakerAxiom = this.dataFactory.getOWLSubClassOfAxiom(ax.getSubClass(), (OWLClassExpression)weaker);
        return this.isEntailedWithReplacement((OWLAxiom)ax, (OWLAxiom)weakerAxiom, axioms, checker);
    }

    private boolean isEntailedWithReplacement(OWLAxiom axiom, OWLAxiom replacementAxiom, Set<OWLAxiom> axioms, EntailmentChecker<OWLAxiom> checker) {
        axioms.remove(axiom);
        axioms.add(replacementAxiom);
        boolean entailed = checker.isEntailed(axioms);
        axioms.remove(replacementAxiom);
        axioms.add(axiom);
        return entailed;
    }

    private Set<OWLAxiom> getFlattenedAxioms(Set<OWLAxiom> axioms) {
        this.deltaTransformation = new DeltaTransformation(this.dataFactory);
        return this.deltaTransformation.transform(axioms);
    }
}

