/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.laconic;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.laconic.BaseDescriptionGenerator;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BetaGenerator
extends BaseDescriptionGenerator {
    public BetaGenerator(OWLDataFactory factory) {
        super(factory);
    }

    public Set<OWLClassExpression> visit(OWLClass desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>(3);
        descs.add((OWLClassExpression)desc);
        descs.add((OWLClassExpression)this.getDataFactory().getOWLNothing());
        return descs;
    }

    public Set<OWLClassExpression> visit(OWLObjectComplementOf desc) {
        HashSet<OWLClassExpression> descs = new HashSet<OWLClassExpression>();
        for (OWLClassExpression d : this.computeTau(desc.getOperand())) {
            descs.add((OWLClassExpression)this.getDataFactory().getOWLObjectComplementOf(d));
        }
        return descs;
    }

    protected Set<OWLClassExpression> compute(OWLClassExpression description) {
        return this.computeBeta(description);
    }

    public Set<OWLClassExpression> visit(OWLObjectMaxCardinality desc) {
        Set<OWLClassExpression> fillers = this.computeTau((OWLClassExpression)desc.getFiller());
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (int n = desc.getCardinality(); n > 0; --n) {
            for (OWLClassExpression filler : fillers) {
                result.add((OWLClassExpression)this.getDataFactory().getOWLObjectMinCardinality(n, (OWLObjectPropertyExpression)desc.getProperty(), filler));
            }
        }
        result.add((OWLClassExpression)this.getLimit());
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectExactCardinality desc) {
        Set<OWLClassExpression> fillers = this.computeBeta((OWLClassExpression)desc.getFiller());
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (OWLClassExpression filler : fillers) {
            result.add((OWLClassExpression)this.getDataFactory().getOWLObjectExactCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), filler));
        }
        result.add((OWLClassExpression)this.getLimit());
        return result;
    }

    @Override
    public Set<OWLClassExpression> visit(OWLObjectUnionOf desc) {
        boolean anon = false;
        for (OWLClassExpression ce : desc.asDisjunctSet()) {
            if (!ce.isAnonymous()) continue;
            anon = true;
            break;
        }
        if (anon) {
            return super.visit(desc);
        }
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        result.addAll(desc.asDisjunctSet());
        return result;
    }

    public Set<OWLClassExpression> visit(OWLObjectMinCardinality desc) {
        Set<OWLClassExpression> fillers = this.computeBeta((OWLClassExpression)desc.getFiller());
        HashSet<OWLClassExpression> result = new HashSet<OWLClassExpression>();
        for (OWLClassExpression filler : fillers) {
            result.add((OWLClassExpression)this.getDataFactory().getOWLObjectMinCardinality(desc.getCardinality(), (OWLObjectPropertyExpression)desc.getProperty(), filler));
        }
        result.add((OWLClassExpression)this.getLimit());
        return result;
    }

    @Override
    protected OWLClass getLimit() {
        return this.getDataFactory().getOWLNothing();
    }

    @Override
    protected OWLDataRange getDataLimit() {
        return this.getDataFactory().getOWLDataComplementOf((OWLDataRange)this.getDataFactory().getTopDatatype());
    }

    @Override
    public Set<OWLClassExpression> visit(OWLDataHasValue desc) {
        return Collections.singleton(desc);
    }
}

