/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.nsp;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.util.OWLObjectPropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSimplePropertyEntailmentChecker
implements EntailmentChecker<OWLObjectPropertyExpression> {
    private OWLObjectPropertyExpression prop;
    private int counter = 0;

    public NonSimplePropertyEntailmentChecker(OWLObjectPropertyExpression prop) {
        this.prop = prop;
    }

    @Override
    public int getCounter() {
        return this.counter;
    }

    @Override
    public void resetCounter() {
        this.counter = 0;
    }

    @Override
    public Set<OWLEntity> getSeedSignature() {
        return this.prop.getSignature();
    }

    @Override
    public OWLObjectPropertyExpression getEntailment() {
        return this.prop;
    }

    @Override
    public Set<OWLEntity> getEntailmentSignature() {
        return this.prop.getSignature();
    }

    @Override
    public boolean isEntailed(Set<OWLAxiom> axioms) {
        try {
            ++this.counter;
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology ont = man.createOntology(axioms);
            OWLObjectPropertyManager propman = new OWLObjectPropertyManager(man, ont);
            return propman.isNonSimple(this.prop);
        }
        catch (OWLOntologyCreationException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public Set<OWLAxiom> getEntailingAxioms(Set<OWLAxiom> axioms) {
        return axioms;
    }

    @Override
    public Set<OWLAxiom> getModule(Set<OWLAxiom> axioms) {
        HashSet<OWLAxiom> module = new HashSet<OWLAxiom>(axioms.size());
        for (OWLAxiom ax : axioms) {
            if (ax instanceof OWLSubPropertyAxiom) {
                module.add(ax);
                continue;
            }
            if (ax instanceof OWLEquivalentObjectPropertiesAxiom) {
                module.add(ax);
                continue;
            }
            if (ax instanceof OWLInverseObjectPropertiesAxiom) {
                module.add(ax);
                continue;
            }
            if (ax instanceof OWLSubPropertyChainOfAxiom) {
                module.add(ax);
                continue;
            }
            if (!(ax instanceof OWLTransitiveObjectPropertyAxiom)) continue;
            module.add(ax);
        }
        return module;
    }

    @Override
    public String getModularisationTypeDescription() {
        return "SubPropertyOf axioms only";
    }

    @Override
    public boolean isUseModularisation() {
        return true;
    }
}

