/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.checker;

import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.blackbox.checker.SatisfiabilityEntailmentChecker;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SatisfiabilityEntailmentCheckerFactory
implements EntailmentCheckerFactory<OWLAxiom> {
    private OWLReasonerFactory reasonerFactory;
    private boolean useModularisation;
    private long entailmentCheckTimeOutMS = Long.MAX_VALUE;

    public SatisfiabilityEntailmentCheckerFactory(OWLReasonerFactory reasonerFactory) {
        this(reasonerFactory, true);
    }

    public SatisfiabilityEntailmentCheckerFactory(OWLReasonerFactory reasonerFactory, long entailmentCheckTimeOutMS) {
        this.reasonerFactory = reasonerFactory;
        this.entailmentCheckTimeOutMS = entailmentCheckTimeOutMS;
        this.useModularisation = true;
    }

    public SatisfiabilityEntailmentCheckerFactory(OWLReasonerFactory reasonerFactory, boolean useModularisation) {
        this.reasonerFactory = reasonerFactory;
        this.useModularisation = useModularisation;
    }

    public SatisfiabilityEntailmentCheckerFactory(OWLReasonerFactory reasonerFactory, boolean useModularisation, long entailmentCheckTimeOutMS) {
        this.reasonerFactory = reasonerFactory;
        this.useModularisation = useModularisation;
        this.entailmentCheckTimeOutMS = entailmentCheckTimeOutMS;
    }

    @Override
    public EntailmentChecker<OWLAxiom> createEntailementChecker(OWLAxiom entailment) {
        return new SatisfiabilityEntailmentChecker(this.reasonerFactory, entailment, this.useModularisation, this.entailmentCheckTimeOutMS);
    }
}

