/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox.checker;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.api.NullExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.BlackBoxExplanationGenerator2;
import org.semanticweb.owl.explanation.impl.blackbox.ExpansionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.InconsistentOntologyContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.InconsistentOntologyExpansionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.checker.ConsistencyEntailmentCheckerFactory;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InconsistentOntologyExplanationGeneratorFactory
implements ExplanationGeneratorFactory<OWLAxiom> {
    private InconsistentOntologyContractionStrategy contractionStrategy;
    private ExpansionStrategy expansionStrategy = new InconsistentOntologyExpansionStrategy();
    private ConsistencyEntailmentCheckerFactory consistencyEntailmentCheckerFactory;

    public InconsistentOntologyExplanationGeneratorFactory(OWLReasonerFactory reasonerFactory, long entailmentCheckingTimeout) {
        this.contractionStrategy = new InconsistentOntologyContractionStrategy();
        this.consistencyEntailmentCheckerFactory = new ConsistencyEntailmentCheckerFactory(reasonerFactory, entailmentCheckingTimeout);
    }

    @Override
    public ExplanationGenerator<OWLAxiom> createExplanationGenerator(OWLOntology ontology) {
        return this.createExplanationGenerator(ontology, (ExplanationProgressMonitor<OWLAxiom>)new NullExplanationProgressMonitor<OWLAxiom>());
    }

    @Override
    public ExplanationGenerator<OWLAxiom> createExplanationGenerator(OWLOntology ontology, ExplanationProgressMonitor<OWLAxiom> progressMonitor) {
        HashSet axioms = new HashSet(ontology.getLogicalAxiomCount());
        for (OWLOntology ont : ontology.getImportsClosure()) {
            axioms.addAll(ont.getLogicalAxioms());
        }
        return new BlackBoxExplanationGenerator2<OWLAxiom>(axioms, this.consistencyEntailmentCheckerFactory, this.expansionStrategy, this.contractionStrategy, progressMonitor);
    }

    @Override
    public ExplanationGenerator<OWLAxiom> createExplanationGenerator(Set<? extends OWLAxiom> axioms) {
        return this.createExplanationGenerator(axioms, (ExplanationProgressMonitor<OWLAxiom>)new NullExplanationProgressMonitor<OWLAxiom>());
    }

    @Override
    public ExplanationGenerator<OWLAxiom> createExplanationGenerator(Set<? extends OWLAxiom> axioms, ExplanationProgressMonitor<OWLAxiom> progressMonitor) {
        return new BlackBoxExplanationGenerator2<OWLAxiom>(axioms, this.consistencyEntailmentCheckerFactory, this.expansionStrategy, this.contractionStrategy, progressMonitor);
    }
}

