/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owlapi.model.OWLAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlidingWindowContractionStrategy
implements ContractionStrategy {
    private final int windowSize;
    private int count;

    public SlidingWindowContractionStrategy() {
        this.windowSize = 20;
    }

    public SlidingWindowContractionStrategy(int windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public Set<OWLAxiom> doPruning(Set<OWLAxiom> axioms, EntailmentChecker checker, ExplanationProgressMonitor<?> progressMonitor) {
        this.count = 0;
        ArrayList<OWLAxiom> axiomList = new ArrayList<OWLAxiom>(axioms);
        int windowCount = axiomList.size() / this.windowSize;
        HashSet<OWLAxiom> contraction = new HashSet<OWLAxiom>(axioms);
        for (int windowIndex = 0; windowIndex < windowCount; ++windowIndex) {
            int start = windowIndex * this.windowSize;
            int end = start + this.windowSize;
            List cur = axiomList.subList(start, end);
            contraction.removeAll(cur);
            ++this.count;
            if (checker.isEntailed(contraction)) continue;
            contraction.addAll(cur);
        }
        HashSet<OWLAxiom> contractionCopy = new HashSet<OWLAxiom>(contraction);
        for (OWLAxiom ax : contractionCopy) {
            contraction.remove(ax);
            ++this.count;
            if (checker.isEntailed(contraction)) continue;
            contraction.add(ax);
        }
        return contraction;
    }

    @Override
    public int getNumberOfSteps() {
        return this.count;
    }
}

