/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternBasedEntailmentChecker {
    private OWLAxiom entailment;
    private OWLSubClassOfAxiom subClassOfEntailment;
    private OWLClassAssertionAxiom classAssertionEntailment;
    private Set<Explanation<OWLAxiom>> simpleExplanations = new HashSet<Explanation<OWLAxiom>>();

    public PatternBasedEntailmentChecker(OWLAxiom entailment, Set<OWLAxiom> workingAxioms) {
        this.entailment = entailment;
        this.subClassOfEntailment = entailment instanceof OWLSubClassOfAxiom ? (OWLSubClassOfAxiom)entailment : null;
        this.classAssertionEntailment = entailment instanceof OWLClassAssertionAxiom ? (OWLClassAssertionAxiom)entailment : null;
        this.processAxioms(workingAxioms);
    }

    public Set<Explanation<OWLAxiom>> getSimpleExplanations() {
        return this.simpleExplanations;
    }

    private void processAxioms(Set<OWLAxiom> axioms) {
        WorkingAxiomVisitor visitor = new WorkingAxiomVisitor();
        for (OWLAxiom ax : axioms) {
            if (this.entailment.equalsIgnoreAnnotations(ax)) {
                Set<OWLAxiom> axs = Collections.singleton(ax);
                this.simpleExplanations.add(new Explanation<OWLAxiom>(this.entailment, axs));
            }
            ax.accept((OWLAxiomVisitor)visitor);
        }
    }

    private void addExplanation(OWLAxiom explanationAxiom) {
    }

    private class WorkingAxiomVisitor
    implements OWLAxiomVisitor {
        private Map<OWLObjectPropertyExpression, Set<OWLAxiom>> existentials = new HashMap<OWLObjectPropertyExpression, Set<OWLAxiom>>();

        private WorkingAxiomVisitor() {
        }

        public void visit(OWLDeclarationAxiom axiom) {
        }

        public void visit(OWLSubClassOfAxiom axiom) {
            if (PatternBasedEntailmentChecker.this.subClassOfEntailment != null) {
                Set superConjuncts = axiom.getSuperClass().asConjunctSet();
                Set subDisjuncts = axiom.getSubClass().asDisjunctSet();
                if (superConjuncts.contains(axiom.getSuperClass()) && subDisjuncts.contains(axiom.getSubClass())) {
                    PatternBasedEntailmentChecker.this.addExplanation((OWLAxiom)axiom);
                }
            }
        }

        public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDisjointClassesAxiom axiom) {
        }

        public void visit(OWLDataPropertyDomainAxiom axiom) {
        }

        public void visit(OWLObjectPropertyDomainAxiom axiom) {
        }

        public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLDifferentIndividualsAxiom axiom) {
        }

        public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        }

        public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLObjectPropertyRangeAxiom axiom) {
        }

        public void visit(OWLObjectPropertyAssertionAxiom axiom) {
            OWLObjectPropertyExpression prop = ((OWLObjectPropertyExpression)axiom.getProperty()).getSimplified();
            Set<OWLAxiom> axioms = this.existentials.get(prop);
            if (axioms == null) {
                axioms = new HashSet<OWLAxiom>();
                this.existentials.put(prop, axioms);
            }
            axioms.add((OWLAxiom)axiom);
        }

        public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        }

        public void visit(OWLDisjointUnionAxiom axiom) {
        }

        public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        }

        public void visit(OWLDataPropertyRangeAxiom axiom) {
        }

        public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        }

        public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        }

        public void visit(OWLClassAssertionAxiom axiom) {
        }

        public void visit(OWLEquivalentClassesAxiom axiom) {
            block2: {
                OWLClassExpression superClass;
                OWLClassExpression subClass;
                block4: {
                    block3: {
                        if (PatternBasedEntailmentChecker.this.subClassOfEntailment == null) break block2;
                        subClass = PatternBasedEntailmentChecker.this.subClassOfEntailment.getSubClass();
                        superClass = PatternBasedEntailmentChecker.this.subClassOfEntailment.getSuperClass();
                        if (!axiom.contains(subClass) || !axiom.contains(superClass)) break block3;
                        PatternBasedEntailmentChecker.this.addExplanation((OWLAxiom)axiom);
                        break block2;
                    }
                    if (!axiom.contains(subClass)) break block4;
                    for (OWLClassExpression ce : axiom.getClassExpressions()) {
                        if (ce.equals(subClass) || !ce.asConjunctSet().contains(superClass)) continue;
                        PatternBasedEntailmentChecker.this.addExplanation((OWLAxiom)axiom);
                        break block2;
                    }
                    break block2;
                }
                if (!axiom.contains(superClass)) break block2;
                for (OWLClassExpression ce : axiom.getClassExpressions()) {
                    if (ce.equals(superClass) || !ce.asDisjunctSet().contains(subClass)) continue;
                    PatternBasedEntailmentChecker.this.addExplanation((OWLAxiom)axiom);
                    break;
                }
            }
        }

        public void visit(OWLDataPropertyAssertionAxiom axiom) {
        }

        public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSubDataPropertyOfAxiom axiom) {
        }

        public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        }

        public void visit(OWLSameIndividualAxiom axiom) {
        }

        public void visit(OWLSubPropertyChainOfAxiom axiom) {
        }

        public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        }

        public void visit(OWLHasKeyAxiom axiom) {
        }

        public void visit(OWLDatatypeDefinitionAxiom axiom) {
        }

        public void visit(SWRLRule rule) {
        }

        public void visit(OWLAnnotationAssertionAxiom axiom) {
        }

        public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        }

        public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        }
    }
}

