/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.owl.explanation.api.ExplanationGeneratorInterruptedException;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owlapi.model.OWLAxiom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DivideAndConquerContractionStrategy
implements ContractionStrategy {
    private int count;

    @Override
    public Set<OWLAxiom> doPruning(Set<OWLAxiom> axioms, EntailmentChecker checker, ExplanationProgressMonitor<?> progressMonitor) {
        this.count = 0;
        ArrayList<OWLAxiom> axiomList = new ArrayList<OWLAxiom>(axioms);
        List<OWLAxiom> result = this.extract(new ArrayList<OWLAxiom>(), axiomList, checker, progressMonitor);
        return new HashSet<OWLAxiom>(result);
    }

    public List<OWLAxiom> extract(List<OWLAxiom> listS, List<OWLAxiom> listO, EntailmentChecker checker, ExplanationProgressMonitor<?> progressMonitor) {
        if (progressMonitor.isCancelled()) {
            throw new ExplanationGeneratorInterruptedException();
        }
        if (listO.size() == 1) {
            return listO;
        }
        ListHalves halves = this.getHalves(listO);
        if (this.isEntailed(listS, halves.getS1(), checker)) {
            return this.extract(listS, halves.getS1(), checker, progressMonitor);
        }
        if (this.isEntailed(listS, halves.getS2(), checker)) {
            return this.extract(listS, halves.getS2(), checker, progressMonitor);
        }
        ArrayList<OWLAxiom> listSWithS2 = new ArrayList<OWLAxiom>(listS);
        listSWithS2.addAll(halves.getS2());
        List<OWLAxiom> listS1Prime = this.extract(listSWithS2, halves.getS1(), checker, progressMonitor);
        ArrayList<OWLAxiom> listSWithS1Prime = new ArrayList<OWLAxiom>(listS);
        listSWithS1Prime.addAll(listS1Prime);
        List<OWLAxiom> listS2Prime = this.extract(listSWithS1Prime, halves.getS2(), checker, progressMonitor);
        ArrayList<OWLAxiom> listS1PrimeWithS2Prime = new ArrayList<OWLAxiom>(listS1Prime);
        listS1PrimeWithS2Prime.addAll(listS2Prime);
        return listS1PrimeWithS2Prime;
    }

    private boolean isEntailed(List<OWLAxiom> listA, List<OWLAxiom> listB, EntailmentChecker checker) {
        ++this.count;
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>((int)((double)(listA.size() + listB.size()) * 1.3));
        axioms.addAll(listA);
        axioms.addAll(listB);
        return checker.isEntailed(axioms);
    }

    private ListHalves getHalves(List<OWLAxiom> axioms) {
        return new ListHalves(axioms);
    }

    @Override
    public int getNumberOfSteps() {
        return this.count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListHalves {
        private List<OWLAxiom> listS1;
        private List<OWLAxiom> listS2;

        public ListHalves(List<OWLAxiom> input) {
            int listASize = input.size() / 2;
            this.listS1 = new ArrayList<OWLAxiom>(input.subList(0, listASize));
            this.listS2 = new ArrayList<OWLAxiom>(input.subList(listASize, input.size()));
        }

        public List<OWLAxiom> getS1() {
            return this.listS1;
        }

        public List<OWLAxiom> getS2() {
            return this.listS2;
        }
    }
}

