/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.impl.blackbox;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owl.explanation.api.Explanation;
import org.semanticweb.owl.explanation.api.ExplanationException;
import org.semanticweb.owl.explanation.api.ExplanationGenerator;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.api.NotEntailedException;
import org.semanticweb.owl.explanation.api.NullExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.ContractionStrategy;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentChecker;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.blackbox.ExpansionStrategy;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import uk.ac.manchester.cs.bhig.util.MutableTree;
import uk.ac.manchester.cs.bhig.util.NodeRenderer;
import uk.ac.manchester.cs.bhig.util.Tree;
import uk.ac.manchester.cs.owl.explanation.ordering.DefaultExplanationOrderer;
import uk.ac.manchester.cs.owl.explanation.ordering.ExplanationTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlackBoxExplanationGenerator<E>
implements ExplanationGenerator<E> {
    public static Logger logger = Logger.getLogger("BlackBoxExplanationGenerator");
    public static Level LEVEL = Level.FINEST;
    private ExpansionStrategy expansionStrategy;
    private ContractionStrategy contractionStrategy;
    private EntailmentCheckerFactory<E> checkerFactory;
    private Set<OWLAxiom> workingAxioms;
    private Set<OWLAxiom> module = null;
    private MutableTree<Explanation> hst;
    private ExplanationProgressMonitor<E> progressMonitor;
    private List<Integer> prunningDifferences = new ArrayList<Integer>();
    private int hittingSetTreeOperationsCount = 0;
    private int counter = 0;
    private Map<OWLAxiom, Integer> axiom2LeafCount = new HashMap<OWLAxiom, Integer>();

    public BlackBoxExplanationGenerator(Set<? extends OWLAxiom> axioms, EntailmentCheckerFactory<E> checkerFactory, ExpansionStrategy expansionStrategy, ContractionStrategy contractionStrategy, ExplanationProgressMonitor<E> progressMonitor) {
        this.workingAxioms = new HashSet<OWLAxiom>(axioms);
        this.checkerFactory = checkerFactory;
        this.expansionStrategy = expansionStrategy;
        this.contractionStrategy = contractionStrategy;
        this.progressMonitor = progressMonitor != null ? progressMonitor : new NullExplanationProgressMonitor();
    }

    protected void addPruningDifference(int diff) {
        this.prunningDifferences.add(diff);
    }

    public List<Integer> getPruningDifferences() {
        return Collections.unmodifiableList(this.prunningDifferences);
    }

    @Override
    public Set<Explanation<E>> getExplanations(E entailment) throws ExplanationException {
        return this.getExplanations(entailment, Integer.MAX_VALUE);
    }

    @Override
    public Set<Explanation<E>> getExplanations(E entailment, int limit) throws ExplanationException {
        try {
            this.module = this.extractModule(this.workingAxioms, this.checkerFactory.createEntailementChecker(entailment));
            this.hittingSetTreeOperationsCount = 0;
            this.prunningDifferences.clear();
            HashSet<Explanation<Explanation<E>>> explanations = new HashSet<Explanation<Explanation<E>>>();
            Explanation<E> expl = this.computeExplanation(entailment);
            explanations.add(expl);
            this.progressMonitor.foundExplanation(this, expl, Collections.unmodifiableSet(explanations));
            if (this.progressMonitor.isCancelled()) {
                return Collections.singleton(expl);
            }
            this.hst = new MutableTree(expl);
            if (expl.isEmpty()) {
                return Collections.emptySet();
            }
            if (limit > 1) {
                this.constructHittingSetTree(entailment, expl, explanations, new HashSet<Set<OWLAxiom>>(), new HashSet<OWLAxiom>(), limit);
            }
            if (explanations.isEmpty()) {
                throw new NotEntailedException(entailment);
            }
            return explanations;
        }
        catch (OWLException e) {
            throw new ExplanationException(e);
        }
    }

    private void dumpHST() {
        try {
            File file = new File("/tmp/hst" + System.currentTimeMillis() + ".txt");
            PrintWriter pw = new PrintWriter(new FileWriter(file));
            this.hst.dump(pw);
            pw.flush();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void dumpHSTStats() {
        HashMap<OWLAxiom, Integer> map = new HashMap<OWLAxiom, Integer>();
        this.collectEmptyNodes((Tree<Explanation>)this.hst, (Map<OWLAxiom, Integer>)map);
        TreeMap orderedMap = new TreeMap();
        for (OWLAxiom ax : map.keySet()) {
            orderedMap.put(map.get(ax), ax);
        }
        for (Integer i : orderedMap.keySet()) {
        }
    }

    private void collectEmptyNodes(Tree<Explanation> exp, Map<OWLAxiom, Integer> axs) {
        for (Tree child : exp.getChildren()) {
            if (((Explanation)child.getUserObject()).getAxioms().isEmpty()) {
                OWLAxiom label = (OWLAxiom)exp.getEdge(child);
                Integer count = axs.get(label);
                if (count == null) {
                    count = 0;
                }
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                axs.put(label, count);
                continue;
            }
            this.collectEmptyNodes((Tree<Explanation>)child, axs);
        }
    }

    public Set<OWLAxiom> getWorkingAxioms() {
        return this.workingAxioms;
    }

    protected Explanation<E> computeExplanation(E entailment) throws OWLException {
        if (BlackBoxExplanationGenerator.isLoggable()) {
            BlackBoxExplanationGenerator.log("Computing explanation");
        }
        ++this.counter;
        EntailmentChecker<E> checker = this.checkerFactory.createEntailementChecker(entailment);
        if (!checker.isEntailed(this.module)) {
            return Explanation.getEmptyExplanation(entailment);
        }
        if (this.progressMonitor.isCancelled()) {
            return Explanation.getEmptyExplanation(entailment);
        }
        Set<OWLAxiom> expandedAxioms = this.expansionStrategy.doExpansion(this.module, checker, this.progressMonitor);
        if (this.progressMonitor.isCancelled()) {
            return Explanation.getEmptyExplanation(entailment);
        }
        this.handlePostExpansion();
        Set<OWLAxiom> expandedAxiomsModule = this.extractModule(expandedAxioms, checker);
        int expandedSize = expandedAxioms.size();
        Set<OWLAxiom> justification = this.contractionStrategy.doPruning(expandedAxiomsModule, checker, this.progressMonitor);
        int contractionSize = justification.size();
        int prunningDifference = expandedSize - contractionSize;
        this.prunningDifferences.add(prunningDifference);
        Explanation<E> expl = new Explanation<E>(entailment, justification);
        this.handlePostContraction(checker, expandedAxioms, justification);
        return expl;
    }

    protected Set<OWLAxiom> extractModule(Set<OWLAxiom> axioms, EntailmentChecker<E> checker) throws OWLOntologyCreationException, OWLOntologyChangeException {
        return checker.getModule(axioms);
    }

    private static <E> List<OWLAxiom> getOrderedJustifications(List<OWLAxiom> mups, final Set<Explanation<E>> allJustifications) {
        Comparator<OWLAxiom> mupsComparator = new Comparator<OWLAxiom>(){

            @Override
            public int compare(OWLAxiom o1, OWLAxiom o2) {
                int occ1 = BlackBoxExplanationGenerator.getOccurrences(o1, allJustifications);
                int occ2 = BlackBoxExplanationGenerator.getOccurrences(o2, allJustifications);
                return -occ1 + occ2;
            }
        };
        Collections.sort(mups, mupsComparator);
        return mups;
    }

    private static <E> int getOccurrences(OWLAxiom ax, Set<Explanation<E>> axiomSets) {
        int count = 0;
        for (Explanation<E> explanation : axiomSets) {
            if (!explanation.getAxioms().contains(ax)) continue;
            ++count;
        }
        return count;
    }

    private void constructHittingSetTree(E entailment, Explanation<E> justification, Set<Explanation<E>> allJustifications, Set<Set<OWLAxiom>> satPaths, Set<OWLAxiom> currentPathContents, int maxExplanations) throws OWLException {
        List<OWLAxiom> orderedJustification = BlackBoxExplanationGenerator.getOrderedJustifications(new ArrayList<OWLAxiom>(justification.getAxioms()), allJustifications);
        while (!orderedJustification.isEmpty()) {
            OWLAxiom axiom = orderedJustification.get(0);
            orderedJustification.remove(0);
            if (allJustifications.size() == maxExplanations) {
                return;
            }
            this.module.remove(axiom);
            currentPathContents.add(axiom);
            boolean earlyTermination = false;
            for (Set<OWLAxiom> satPath : satPaths) {
                if (!currentPathContents.containsAll(satPath)) continue;
                earlyTermination = true;
                break;
            }
            if (!earlyTermination) {
                Explanation<E> newJustification = null;
                for (Explanation<E> explanation : allJustifications) {
                    HashSet<OWLAxiom> foundMUPSCopy = new HashSet<OWLAxiom>(explanation.getAxioms());
                    foundMUPSCopy.retainAll(currentPathContents);
                    if (!foundMUPSCopy.isEmpty()) continue;
                    newJustification = explanation;
                    break;
                }
                if (newJustification == null) {
                    newJustification = this.computeExplanation(entailment);
                }
                if (axiom.isLogicalAxiom() && newJustification.contains(axiom)) {
                    throw new OWLRuntimeException("Explanation contains removed axiom: " + axiom + " (Working axioms contains axiom: " + this.module.contains(axiom) + ")");
                }
                if (!newJustification.isEmpty()) {
                    boolean added = allJustifications.add(newJustification);
                    if (added) {
                        this.progressMonitor.foundExplanation(this, newJustification, allJustifications);
                    }
                    if (this.progressMonitor.isCancelled()) {
                        return;
                    }
                    this.constructHittingSetTree(entailment, newJustification, allJustifications, satPaths, currentPathContents, maxExplanations);
                    orderedJustification = BlackBoxExplanationGenerator.getOrderedJustifications(orderedJustification, allJustifications);
                } else {
                    satPaths.add(new HashSet<OWLAxiom>(currentPathContents));
                    Explanation<E> exp = new Explanation<E>(entailment, new HashSet<OWLAxiom>(0));
                    MutableTree mutableTree = new MutableTree(exp);
                }
            }
            currentPathContents.remove(axiom);
            this.module.add(axiom);
        }
    }

    private void dumpHSTNodeDiagnostics(E entailment, Explanation<E> justification, Set<Explanation<E>> allJustifications, Set<OWLAxiom> currentPathContents) {
        ++this.hittingSetTreeOperationsCount;
        StringBuilder sb = new StringBuilder();
        sb.append("FOR ");
        sb.append(entailment);
        sb.append(" (");
        sb.append(allJustifications.size());
        sb.append(" explanations found so far)\n");
        sb.append("    CALLS TO BUILD HST: ");
        sb.append(this.hittingSetTreeOperationsCount);
        sb.append("\n");
        sb.append("    CURRENT NODE SIZE: ");
        sb.append(justification.getAxioms().size());
        sb.append("\n");
        sb.append("    EXTENDING HST (In path of depth ");
        sb.append(currentPathContents.size());
        sb.append(")");
    }

    private void incremeSnt(OWLAxiom ax) {
        Integer i = this.axiom2LeafCount.get(ax);
        if (i == null) {
            i = 0;
        }
        Integer n = i;
        Integer n2 = i = Integer.valueOf(i + 1);
        this.axiom2LeafCount.put(ax, i);
    }

    private static boolean isLoggable() {
        return logger.isLoggable(LEVEL);
    }

    private static void log(String s) {
        logger.log(LEVEL, s);
    }

    private void handlePostExpansion() {
        if (BlackBoxExplanationGenerator.isLoggable()) {
            BlackBoxExplanationGenerator.log("Completed expansion");
        }
    }

    private void handlePostContraction(EntailmentChecker<E> checker, Set<OWLAxiom> expandedAxioms, final Set<OWLAxiom> justification) {
        if (BlackBoxExplanationGenerator.isLoggable()) {
            BlackBoxExplanationGenerator.log("Expanding axioms");
            StringBuilder sb = new StringBuilder();
            DefaultExplanationOrderer orderer = new DefaultExplanationOrderer();
            ExplanationTree tree = orderer.getOrderedExplanation((OWLAxiom)checker.getEntailment(), expandedAxioms);
            List axiomList = tree.fillDepthFirst();
            for (OWLAxiom ax : axiomList) {
                if (justification.contains(ax)) {
                    sb.append("*\t");
                    sb.append(ax);
                    sb.append("\n");
                    continue;
                }
                sb.append(" \t");
                sb.append(ax);
                sb.append("\n");
            }
            sb.append("----------------------------\n");
            tree.setNodeRenderer((NodeRenderer)new NodeRenderer<OWLAxiom>(){

                public String render(Tree<OWLAxiom> node) {
                    if (justification.contains(node.getUserObject())) {
                        return "*\t" + node;
                    }
                    return " \t" + node;
                }
            });
            StringWriter sw = new StringWriter();
            tree.dump(new PrintWriter(sw));
            sb.append(sw);
            BlackBoxExplanationGenerator.log(sb.toString());
        }
    }
}

