/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.api;

import org.semanticweb.owl.explanation.api.ExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.api.ExplanationProgressMonitor;
import org.semanticweb.owl.explanation.impl.blackbox.Configuration;
import org.semanticweb.owl.explanation.impl.blackbox.EntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.blackbox.checker.BlackBoxExplanationGeneratorFactory;
import org.semanticweb.owl.explanation.impl.blackbox.checker.SatisfiabilityEntailmentCheckerFactory;
import org.semanticweb.owl.explanation.impl.laconic.LaconicExplanationGeneratorFactory;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExplanationManager {
    public static ExplanationGeneratorFactory<OWLAxiom> createExplanationGeneratorFactory(OWLReasonerFactory reasonerFactory) {
        return ExplanationManager.createExplanationGeneratorFactory(reasonerFactory, null);
    }

    public static ExplanationGeneratorFactory<OWLAxiom> createExplanationGeneratorFactory(OWLReasonerFactory reasonerFactory, ExplanationProgressMonitor<OWLAxiom> progressMonitor) {
        SatisfiabilityEntailmentCheckerFactory checker = new SatisfiabilityEntailmentCheckerFactory(reasonerFactory);
        Configuration<OWLAxiom> config = new Configuration<OWLAxiom>(checker, progressMonitor);
        return new BlackBoxExplanationGeneratorFactory<OWLAxiom>(config);
    }

    public static ExplanationGeneratorFactory<OWLAxiom> createLaconicExplanationGeneratorFactory(OWLReasonerFactory reasonerFactory) {
        return ExplanationManager.createLaconicExplanationGeneratorFactory(reasonerFactory, null);
    }

    public static ExplanationGeneratorFactory<OWLAxiom> createLaconicExplanationGeneratorFactory(OWLReasonerFactory reasonerFactory, ExplanationProgressMonitor<OWLAxiom> progressMonitor) {
        return new LaconicExplanationGeneratorFactory<OWLAxiom>(ExplanationManager.createExplanationGeneratorFactory(reasonerFactory));
    }

    public static <E> ExplanationGeneratorFactory<E> createExplanationGeneratorFactory(EntailmentCheckerFactory<E> entailmentCheckerFactory) {
        Configuration<E> config = new Configuration<E>(entailmentCheckerFactory);
        return new BlackBoxExplanationGeneratorFactory<E>(config);
    }

    public static <E> ExplanationGeneratorFactory<E> createLaconicExplanationGeneratorFactory(EntailmentCheckerFactory<E> entailmentCheckerFactory) {
        return new LaconicExplanationGeneratorFactory<E>(ExplanationManager.createExplanationGeneratorFactory(entailmentCheckerFactory));
    }
}

