/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owl.explanation.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import uk.ac.manchester.cs.owl.explanation.ordering.DefaultExplanationOrderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Explanation<E> {
    public static final IRI ENTAILMENT_MARKER_IRI = IRI.create((String)"http://owl.cs.manchester.ac.uk/explanation/vocabulary#entailment");
    private E entailment;
    private Set<OWLAxiom> justification;

    public E getEntailment() {
        return this.entailment;
    }

    public Set<OWLAxiom> getAxioms() {
        return this.justification;
    }

    public int getSize() {
        return this.justification.size();
    }

    public boolean isEmpty() {
        return this.justification.isEmpty();
    }

    public boolean contains(OWLAxiom axiom) {
        return this.justification.contains(axiom);
    }

    public boolean isJustificationEntailment() {
        return ((Object)Collections.singleton(this.entailment)).equals(this.justification);
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        HashSet<OWLClassExpression> subConcepts = new HashSet<OWLClassExpression>();
        for (OWLAxiom ax : this.justification) {
            subConcepts.addAll(ax.getNestedClassExpressions());
        }
        return subConcepts;
    }

    public Explanation(E entailment, Set<OWLAxiom> justification) {
        this.entailment = entailment;
        this.justification = Collections.unmodifiableSet(new HashSet<OWLAxiom>(justification));
    }

    public static <E> Explanation<E> getEmptyExplanation(E entailment) {
        Set<OWLAxiom> emptySet = Collections.emptySet();
        return new Explanation<E>(entailment, emptySet);
    }

    public String toString() {
        AbstractCollection orderedAxioms;
        StringBuilder sb = new StringBuilder();
        if (this.justification.isEmpty()) {
            return "Explanation: <Empty>\n";
        }
        sb.append("Explanation <");
        sb.append(this.entailment);
        sb.append(">\n");
        if (this.entailment instanceof OWLAxiom) {
            OWLAxiom entailedAxiom = (OWLAxiom)this.entailment;
            DefaultExplanationOrderer orderer = new DefaultExplanationOrderer();
            ArrayList axs = new ArrayList(orderer.getOrderedExplanation(entailedAxiom, this.justification).fillDepthFirst());
            axs.remove(0);
            orderedAxioms = axs;
        } else {
            orderedAxioms = new TreeSet<OWLAxiom>(this.justification);
        }
        for (OWLAxiom ax : orderedAxioms) {
            sb.append("\t");
            sb.append(ax);
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Explanation)) {
            return false;
        }
        Explanation other = (Explanation)obj;
        return other.getEntailment().equals(this.entailment) && ((Object)other.getAxioms()).equals(this.justification);
    }

    public int hashCode() {
        return (this.entailment != null ? this.entailment.hashCode() : 0) + ((Object)this.justification).hashCode();
    }

    public static void store(Explanation<OWLAxiom> explanation, OutputStream os) throws IOException {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.createOntology(explanation.getAxioms());
            OWLDataFactory df = manager.getOWLDataFactory();
            OWLAnnotationProperty entailmentMarkerAnnotationProperty = df.getOWLAnnotationProperty(ENTAILMENT_MARKER_IRI);
            OWLAnnotation entailmentAnnotation = df.getOWLAnnotation(entailmentMarkerAnnotationProperty, (OWLAnnotationValue)df.getOWLLiteral(true));
            OWLAxiom annotatedEntailment = explanation.getEntailment().getAnnotatedAxiom(Collections.singleton(entailmentAnnotation));
            manager.addAxiom(ontology, annotatedEntailment);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(os);
            OWLXMLOntologyFormat justificationOntologyFormat = new OWLXMLOntologyFormat();
            manager.saveOntology(ontology, (OWLOntologyFormat)justificationOntologyFormat, (OutputStream)bufferedOutputStream);
        }
        catch (OWLOntologyStorageException e) {
            throw new RuntimeException(e);
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Explanation<OWLAxiom> load(InputStream is) throws IOException {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            OWLOntology ontology = manager.loadOntologyFromOntologyDocument((InputStream)new BufferedInputStream(is));
            OWLDataFactory df = manager.getOWLDataFactory();
            OWLAnnotationProperty entailmentMarkerAnnotationProperty = df.getOWLAnnotationProperty(ENTAILMENT_MARKER_IRI);
            HashSet<OWLAxiom> justificationAxioms = new HashSet<OWLAxiom>();
            OWLAxiom entailment = null;
            for (OWLAxiom ax : ontology.getAxioms()) {
                boolean isEntailmentAxiom;
                boolean bl = isEntailmentAxiom = !ax.getAnnotations(entailmentMarkerAnnotationProperty).isEmpty();
                if (!isEntailmentAxiom) {
                    justificationAxioms.add(ax);
                    continue;
                }
                entailment = ax.getAxiomWithoutAnnotations();
            }
            if (entailment == null) {
                throw new IllegalStateException("Not a serialisation of an Explanation");
            }
            return new Explanation<Object>(entailment, (Set<OWLAxiom>)justificationAxioms);
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }
}

