/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.testing;

import java.io.File;
import java.io.IOException;
import org.semanticweb.elk.io.FileUtils;

public class TestUtils {
    public static final String TEST_ROOT = ".test-home";

    public static void createTestEnvironment(File baseDir) {
        File root = new File(baseDir.getAbsolutePath() + "/" + TEST_ROOT);
        if (root.exists()) {
            try {
                FileUtils.deleteRecursively((File)root);
            }
            catch (IOException e) {
                throw new RuntimeException("Initialization of test environment failed, unable to delete the root test folder");
            }
        }
        if (!root.mkdirs()) {
            throw new RuntimeException("Initialization of test environment failed, unable to create the root test folder");
        }
    }

    public static void cleanUp(File baseDir) {
        try {
            File root = new File(baseDir.getAbsolutePath() + "/" + TEST_ROOT);
            if (root.exists()) {
                FileUtils.deleteRecursively((File)root);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Clean-up of test environment failed, unable to delete the root test folder");
        }
    }

    public static void cleanUpOnExit(File baseDir) {
        File root = new File(baseDir.getAbsolutePath() + "/" + TEST_ROOT);
        if (root.exists()) {
            try {
                FileUtils.deleteRecursively((File)root, (boolean)true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

