/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.testing;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class PolySuite
extends Suite {
    private final List<Runner> runners;

    public PolySuite(Class<?> c) throws Throwable {
        super(c, Collections.emptyList());
        TestClass testClass = this.getTestClass();
        Class jTestClass = testClass.getJavaClass();
        Configuration configuration = PolySuite.getConfiguration(testClass);
        ArrayList<Runner> runners = new ArrayList<Runner>();
        int size = configuration.size();
        for (int i = 0; i < size; ++i) {
            SingleRunner runner = new SingleRunner(jTestClass, configuration.getTestValue(i), configuration.getTestName(i));
            runners.add((Runner)runner);
        }
        this.runners = runners;
    }

    protected List<Runner> getChildren() {
        return this.runners;
    }

    private static Configuration getConfiguration(TestClass testClass) throws Throwable {
        return (Configuration)PolySuite.getConfigMethod(testClass).invokeExplosively(null, new Object[0]);
    }

    private static FrameworkMethod getConfigMethod(TestClass testClass) {
        List methods = testClass.getAnnotatedMethods(Config.class);
        if (methods.isEmpty()) {
            throw new IllegalStateException("@" + Config.class.getSimpleName() + " method not found");
        }
        if (methods.size() > 1) {
            throw new IllegalStateException("Too many @" + Config.class.getSimpleName() + " methods");
        }
        FrameworkMethod method = (FrameworkMethod)methods.get(0);
        int modifiers = method.getMethod().getModifiers();
        if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            throw new IllegalStateException("@" + Config.class.getSimpleName() + " method \"" + method.getName() + "\" must be public static");
        }
        return method;
    }

    private static class SingleRunner
    extends BlockJUnit4ClassRunner {
        private final Object testVal;
        private final String testName;

        SingleRunner(Class<?> testClass, Object testVal, String testName) throws InitializationError {
            super(testClass);
            this.testVal = testVal;
            this.testName = testName;
        }

        protected Object createTest() throws Exception {
            return this.getTestClass().getOnlyConstructor().newInstance(this.testVal);
        }

        protected String getName() {
            return this.testName;
        }

        protected String testName(FrameworkMethod method) {
            return this.testName + ": " + method.getName();
        }

        protected void validateConstructor(List<Throwable> errors) {
            this.validateOnlyOneConstructor(errors);
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }

    public static interface Configuration {
        public int size();

        public Object getTestValue(int var1);

        public String getTestName(int var1);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Config {
    }
}

