/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.testing;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.semanticweb.elk.io.FileUtils;
import org.semanticweb.elk.io.IOUtils;
import org.semanticweb.elk.testing.PolySuite;
import org.semanticweb.elk.testing.SimpleConfiguration;
import org.semanticweb.elk.testing.TestInput;
import org.semanticweb.elk.testing.TestManifest;
import org.semanticweb.elk.testing.TestOutput;
import org.semanticweb.elk.testing.io.URLTestIO;

public class ConfigurationUtils {
    public static <I extends TestInput, EO extends TestOutput, AO extends TestOutput> PolySuite.Configuration loadFileBasedTestConfiguration(String path, Class<?> srcClass, String inputFileExt, String outputFileExt, TestManifestCreator<URLTestIO, EO, AO> creator) throws IOException, URISyntaxException {
        URI srcURI = srcClass.getClassLoader().getResource(path).toURI();
        List inputs = srcURI.isOpaque() ? IOUtils.getResourceNamesFromJAR((String)path, (String)inputFileExt, srcClass) : IOUtils.getResourceNamesFromDir((File)new File(srcURI), (String)inputFileExt);
        List results = srcURI.isOpaque() ? IOUtils.getResourceNamesFromJAR((String)path, (String)outputFileExt, srcClass) : IOUtils.getResourceNamesFromDir((File)new File(srcURI), (String)outputFileExt);
        Collections.sort(inputs);
        Collections.sort(results);
        ArrayList manifests = new ArrayList(inputs.size());
        Iterator<String> resultIter = results.iterator();
        Iterator<String> inputIter = inputs.iterator();
        if (!ConfigurationUtils.endOfData(inputIter, resultIter)) {
            String nextResult = resultIter.next();
            String nextInput = inputIter.next();
            while (true) {
                int cmp;
                if ((cmp = FileUtils.dropExtension((String)nextResult, (String)outputFileExt).compareTo(FileUtils.dropExtension((String)nextInput, (String)inputFileExt))) == 0) {
                    URL resultURL;
                    URL inputURL = srcClass.getClassLoader().getResource(nextInput);
                    TestManifest<URLTestIO, EO, AO> manifest = creator.create(inputURL, resultURL = srcClass.getClassLoader().getResource(nextResult));
                    if (manifest != null) {
                        manifests.add(manifest);
                    }
                    if (ConfigurationUtils.endOfData(inputIter, resultIter)) break;
                    nextInput = inputIter.next();
                    nextResult = resultIter.next();
                    continue;
                }
                if (cmp > 0) {
                    if (ConfigurationUtils.endOfData(inputIter, resultIter)) break;
                    nextInput = inputIter.next();
                    continue;
                }
                if (cmp >= 0) continue;
                if (ConfigurationUtils.endOfData(inputIter, resultIter)) break;
                nextResult = resultIter.next();
            }
        }
        return new SimpleConfiguration(manifests);
    }

    public static <I extends TestInput, EO extends TestOutput, AO extends TestOutput> PolySuite.Configuration loadFileBasedTestConfiguration(String path, Class<?> srcClass, String inputFileExt, TestManifestCreator<URLTestIO, EO, AO> creator) throws IOException, URISyntaxException {
        URI srcURI = srcClass.getClassLoader().getResource(path).toURI();
        List inputs = srcURI.isOpaque() ? IOUtils.getResourceNamesFromJAR((String)path, (String)inputFileExt, srcClass) : IOUtils.getResourceNamesFromDir((File)new File(srcURI), (String)inputFileExt);
        ArrayList manifests = new ArrayList(inputs.size());
        for (String input : inputs) {
            URL inputURL = srcClass.getClassLoader().getResource(input);
            TestManifest<URLTestIO, EO, AO> manifest = creator.create(inputURL, null);
            if (manifest == null) continue;
            manifests.add(manifest);
        }
        return new SimpleConfiguration(manifests);
    }

    private static boolean endOfData(Iterator<String> inputIter, Iterator<String> resultIter) {
        return !resultIter.hasNext() || !inputIter.hasNext();
    }

    public static interface TestManifestCreator<I extends TestInput, EO extends TestOutput, AO extends TestOutput> {
        public TestManifest<I, EO, AO> create(URL var1, URL var2) throws IOException;
    }
}

