/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.logging;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.semanticweb.elk.util.hashing.HashGenerator;

public class ElkTimer {
    public static final int RECORD_NONE = 0;
    public static final int RECORD_CPUTIME = 1;
    public static final int RECORD_WALLTIME = 2;
    public static final int RECORD_ALL = 3;
    static final ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
    static final ConcurrentHashMap<ElkTimer, ElkTimer> registeredTimers = new ConcurrentHashMap();
    protected final String name;
    protected final long threadId;
    protected final int todoFlags;
    protected long currentStartCpuTime = -1L;
    protected long currentStartWallTime = -1L;
    protected boolean isRunning = false;
    protected long totalCpuTime = 0L;
    protected long totalWallTime = 0L;
    protected int measurements = 0;
    protected int threadCount = 0;

    public ElkTimer(String name, int todoFlags, long threadId) {
        this.name = name;
        this.todoFlags = todoFlags;
        this.threadId = threadId;
        if (!tmxb.isThreadCpuTimeEnabled()) {
            tmxb.setThreadCpuTimeEnabled(true);
        }
    }

    public static ElkTimer getTimerForCurrentThread(String name, int todoFlags) {
        return new ElkTimer(name, todoFlags, Thread.currentThread().getId());
    }

    public long getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public long getAvgCpuTime() {
        return this.totalCpuTime > 0L && this.measurements > 0 ? this.totalCpuTime / (long)this.measurements : -1L;
    }

    public String getName() {
        return this.name;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public long getTotalWallTime() {
        return this.totalWallTime;
    }

    public long getAvgWallTime() {
        return this.totalWallTime > 0L && this.measurements > 0 ? this.totalWallTime / (long)this.measurements : -1L;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public synchronized void start() {
        this.currentStartCpuTime = (this.todoFlags & 1) != 0 ? ElkTimer.getThreadCpuTime(this.threadId) : -1L;
        this.currentStartWallTime = (this.todoFlags & 2) != 0 ? System.nanoTime() : -1L;
        this.isRunning = true;
    }

    public synchronized void reset() {
        this.currentStartCpuTime = -1L;
        this.currentStartWallTime = -1L;
        this.totalCpuTime = 0L;
        this.totalWallTime = 0L;
    }

    public synchronized long stop() {
        long cpuTime;
        long totalTime = -1L;
        if ((this.todoFlags & 1) != 0 && this.currentStartCpuTime != -1L && (cpuTime = ElkTimer.getThreadCpuTime(this.threadId)) != -1L) {
            totalTime = cpuTime - this.currentStartCpuTime;
            this.totalCpuTime += totalTime;
        }
        if ((this.todoFlags & 2) != 0 && this.currentStartWallTime != -1L) {
            long wallTime = System.nanoTime();
            this.totalWallTime += wallTime - this.currentStartWallTime;
        }
        if (this.isRunning) {
            ++this.measurements;
            this.isRunning = false;
        }
        this.currentStartWallTime = -1L;
        this.currentStartCpuTime = -1L;
        return totalTime;
    }

    public void log(Logger logger) {
        this.log(logger, (Priority)Level.DEBUG);
    }

    public void log(Logger logger, Priority priority) {
        if (logger.isEnabledFor(priority)) {
            String timerLabel = this.threadId != 0L ? this.name + " (thread " + this.threadId + ")" : (this.threadCount > 1 ? this.name + " (over " + this.threadCount + " threads)" : this.name);
            if (this.todoFlags == 0) {
                logger.log(priority, (Object)("Timer " + timerLabel + " recorded " + this.measurements + " run(s), no times taken"));
            } else {
                String separator;
                String labels = "";
                String values = "";
                if ((this.todoFlags & 1) != 0 && this.threadId != 0L) {
                    labels = labels + "CPU";
                    values = values + this.totalCpuTime / 1000000L;
                    separator = "/";
                } else {
                    separator = "";
                }
                if ((this.todoFlags & 2) != 0) {
                    labels = labels + separator + "Wall";
                    values = values + separator + this.totalWallTime / 1000000L;
                }
                if ((this.todoFlags & 1) != 0 && this.threadId != 0L) {
                    labels = labels + "/CPU avg";
                    values = values + "/" + (float)this.totalCpuTime / (float)this.measurements / 1000000.0f;
                }
                if ((this.todoFlags & 2) != 0) {
                    labels = labels + "/Wall avg";
                    values = values + "/" + (float)this.totalWallTime / (float)this.measurements / 1000000.0f;
                }
                if (this.threadCount > 1) {
                    if ((this.todoFlags & 1) != 0 && this.threadId != 0L) {
                        labels = labels + "/CPU per thread";
                        values = values + "/" + (float)this.totalCpuTime / (float)this.threadCount / 1000000.0f;
                    }
                    if ((this.todoFlags & 2) != 0) {
                        labels = labels + "/Wall per thread";
                        values = values + "/" + (float)this.totalWallTime / (float)this.threadCount / 1000000.0f;
                    }
                }
                logger.log(priority, (Object)("Time for " + timerLabel + " for " + this.measurements + " run(s) " + labels + " (ms): " + values));
            }
            if (this.isRunning) {
                logger.warn((Object)("Timer " + timerLabel + " logged while it was still running"));
            }
        }
    }

    public static void startNamedTimer(String timerName) {
        ElkTimer.getNamedTimer(timerName).start();
    }

    public static void startNamedTimer(String timerName, int todoFlags) {
        ElkTimer.getNamedTimer(timerName, todoFlags).start();
    }

    public static void startNamedTimer(String timerName, int todoFlags, long threadId) {
        ElkTimer.getNamedTimer(timerName, todoFlags, threadId).start();
    }

    public static long stopNamedTimer(String timerName) {
        return ElkTimer.stopNamedTimer(timerName, 3, Thread.currentThread().getId());
    }

    public static long stopNamedTimer(String timerName, int todoFlags) {
        return ElkTimer.stopNamedTimer(timerName, todoFlags, Thread.currentThread().getId());
    }

    public static long stopNamedTimer(String timerName, int todoFlags, long threadId) {
        ElkTimer key = new ElkTimer(timerName, todoFlags, threadId);
        if (registeredTimers.containsKey(key)) {
            return registeredTimers.get(key).stop();
        }
        return -1L;
    }

    public static void resetNamedTimer(String timerName) {
        ElkTimer.getNamedTimer(timerName).reset();
    }

    public static void resetNamedTimer(String timerName, int todoFlags) {
        ElkTimer.getNamedTimer(timerName, todoFlags).reset();
    }

    public static void resetNamedTimer(String timerName, int todoFlags, long threadId) {
        ElkTimer.getNamedTimer(timerName, todoFlags, threadId).reset();
    }

    public static ElkTimer getNamedTimer(String timerName) {
        return ElkTimer.getNamedTimer(timerName, 3, Thread.currentThread().getId());
    }

    public static ElkTimer getNamedTimer(String timerName, int todoFlags) {
        return ElkTimer.getNamedTimer(timerName, todoFlags, Thread.currentThread().getId());
    }

    public static ElkTimer getNamedTimer(String timerName, int todoFlags, long threadId) {
        ElkTimer key = new ElkTimer(timerName, todoFlags, threadId);
        registeredTimers.putIfAbsent(key, key);
        return registeredTimers.get(key);
    }

    public static ElkTimer getNamedTotalTimer(String timerName) {
        long totalCpuTime = 0L;
        long totalSystemTime = 0L;
        int measurements = 0;
        int threadCount = 0;
        int todoFlags = 0;
        ElkTimer previousTimer = null;
        for (Map.Entry<ElkTimer, ElkTimer> entry : registeredTimers.entrySet()) {
            if (!entry.getValue().name.equals(timerName)) continue;
            previousTimer = entry.getValue();
            ++threadCount;
            totalCpuTime += previousTimer.totalCpuTime;
            totalSystemTime += previousTimer.totalWallTime;
            measurements += previousTimer.measurements;
            todoFlags |= previousTimer.todoFlags;
        }
        if (threadCount == 1) {
            return previousTimer;
        }
        ElkTimer result = new ElkTimer(timerName, todoFlags, 0L);
        result.totalCpuTime = totalCpuTime;
        result.totalWallTime = totalSystemTime;
        result.measurements = measurements;
        result.threadCount = threadCount;
        return result;
    }

    public static void logAllNamedTimers(String timerName, Logger logger) {
        ElkTimer.logAllNamedTimers(timerName, logger, (Priority)Level.DEBUG);
    }

    public static void logAllNamedTimers(String timerName, Logger logger, Priority priority) {
        for (Map.Entry<ElkTimer, ElkTimer> entry : registeredTimers.entrySet()) {
            if (!entry.getValue().name.equals(timerName)) continue;
            entry.getValue().log(logger, priority);
        }
    }

    public int hashCode() {
        int nameHash = this.name.hashCode();
        int threadIdHash = new Long(this.threadId).hashCode();
        int todoFlagsHash = new Integer(this.todoFlags).hashCode();
        return HashGenerator.combineListHash((int[])new int[]{nameHash, todoFlagsHash, threadIdHash});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.threadId == ((ElkTimer)obj).threadId && this.todoFlags == ((ElkTimer)obj).todoFlags && this.name.equals(((ElkTimer)obj).name);
    }

    protected static long getThreadCpuTime(long threadId) {
        if (threadId == 0L) {
            return 0L;
        }
        return tmxb.getThreadCpuTime(threadId);
    }
}

